/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeFileReferenceSet;
import com.jetbrains.cmake.psi.CMakeLiteralMixin;
import com.jetbrains.cmake.resolve.CMakeCommandReference;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeLiteralImplMixin
extends CMakeElementBase
implements CMakeLiteralMixin {
    public CMakeLiteralImplMixin(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        CMakeRenameUtils.renameArgument(this.getProject(), name2, this.getNode());
        return this;
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference cMakeCommandReference = this.getCMakeCommandReference();
        if (cMakeCommandReference != null) {
            return cMakeCommandReference;
        }
        return super.getReference();
    }

    @Nullable
    private PsiReference getCMakeCommandReference() {
        CMakeArgument parent;
        if (this.getParent() instanceof CMakeArgument && ((parent = (CMakeArgument)this.getParent()).isCommandDefinitionName() || parent.isEndCommandDefinitionName(this.getText()))) {
            return new CMakeCommandReference(parent, parent.getTextRange());
        }
        return null;
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        PsiElement[] children;
        if (this.getFirstChild() != null) {
            return this.getFirstChild().getText();
        }
        for (PsiElement element : children = this.getChildren()) {
            if (element == null) continue;
            return element.getText();
        }
        return "";
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.getArgument().isCommandDefinitionName() || this.getArgument().isEndCommandDefinitionName(this.getText())) {
            PsiReference commandReference = this.getCMakeCommandReference();
            if (commandReference != null) {
                return new PsiReference[]{commandReference};
            }
            return PsiReference.EMPTY_ARRAY;
        }
        FileReferenceSet set = this.createSet();
        ArrayList ret = new ArrayList();
        PsiReference commandReference = this.getReference();
        ContainerUtil.addIfNotNull(ret, (Object)commandReference);
        Collections.addAll(ret, set.getAllReferences());
        return ret.toArray(PsiReference.EMPTY_ARRAY);
    }

    @NotNull
    public FileReferenceSet createSet() {
        CMakeLiteralImplMixin element = this;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement((PsiElement)element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        return new CMakeFileReferenceSet(text, this, offset, null, SystemInfo.isFileSystemCaseSensitive, false);
    }

    @Override
    public CMakeArgument getArgument() {
        return (CMakeArgument)this.getParent();
    }

    @Override
    public boolean equalByText(CMakeLiteralMixin cMakeLiteralMixin) {
        return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, cMakeLiteralMixin);
    }
}

