/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeLexer;
import com.jetbrains.cmake.psi.CMakeParser;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CMakeParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project2) {
        return new CMakeLexer();
    }

    public PsiParser createParser(Project project2) {
        return new CMakeParser();
    }

    public IFileElementType getFileNodeType() {
        return CMakeElementTypes.CMAKE_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return CMakeElementTypes.WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return CMakeElementTypes.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return CMakeElementTypes.LITERALS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return CMakeTokenTypes.Factory.createElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new CMakeFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

