/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cmake.CMakeFileLocationProvider;
import java.io.File;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CMakeFileLocationUtil {
    @NotNull
    public static String getLocationInFile(@NotNull PsiElement elementInCMakeFile, boolean addLineNumber) {
        PsiFile cmdFile = elementInCMakeFile.getContainingFile();
        VirtualFile virtualFile = cmdFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = cmdFile.getOriginalFile().getVirtualFile();
        }
        String relativePathToRoot = cmdFile.getName();
        Project project2 = cmdFile.getProject();
        if (virtualFile != null) {
            CMakeFileLocationProvider each;
            VirtualFile rootDir = null;
            Iterator iterator2 = CMakeFileLocationProvider.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && (rootDir = (each = (CMakeFileLocationProvider)iterator2.next()).getSourceDirectoryFor(project2, virtualFile)) == null) {
            }
            if (rootDir == null) {
                rootDir = ProjectFileIndex.getInstance((Project)project2).getContentRootForFile(virtualFile.getParent());
            }
            if (rootDir != null) {
                String path = virtualFile.getPath();
                String relativePath = FileUtil.getRelativePath((File)new File(FileUtil.toCanonicalPath((String)rootDir.getPath())), (File)new File(path));
                relativePathToRoot = relativePath == null ? path : relativePath;
            }
        }
        relativePathToRoot = FileUtil.toSystemDependentName((String)relativePathToRoot);
        if (addLineNumber) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument(cmdFile);
            if (doc == null) {
                doc = EditorFactory.getInstance().createDocument((CharSequence)cmdFile.getText());
            }
            int cmdLine = doc.getLineNumber(elementInCMakeFile.getTextOffset()) + 1;
            return relativePathToRoot + ":" + cmdLine;
        }
        return relativePathToRoot;
    }
}

