/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeTokenTypes;

public class CMakeRenameInputValidator
implements RenameInputValidator {
    private final NamesValidator myNamesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)CMakeLanguage.INSTANCE);

    public ElementPattern<? extends PsiElement> getPattern() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)CMakeTokenTypes.C_MAKE_ARGUMENT), PlatformPatterns.psiElement((IElementType)CMakeTokenTypes.C_MAKE_COMMAND_NAME)});
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        if (element instanceof CMakeArgument && ((CMakeArgument)element).isCommandDefinitionName() || element instanceof CMakeCommandName) {
            return this.myNamesValidator.isIdentifier(newName, element.getProject());
        }
        return true;
    }
}

