/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.resolve;

import com.intellij.psi.PsiElement;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCommandReferenceHelper {
    public static boolean isArgument(@Nullable PsiElement possibleCommandDefinition) {
        return possibleCommandDefinition instanceof CMakeArgument || possibleCommandDefinition instanceof CMakeLiteral;
    }

    @NotNull
    public static CMakeArgument getCMakeArgument(@NotNull PsiElement literalOrArgument) {
        CMakeArgument cMakeArgument = literalOrArgument instanceof CMakeLiteral ? (CMakeArgument)literalOrArgument.getParent() : (CMakeArgument)literalOrArgument;
        return cMakeArgument;
    }

    public static boolean commandNamesEqualByText(@Nullable PsiElement name1, @Nullable PsiElement name2) {
        PsiElement firstLiteral = name1;
        PsiElement secondLiteral = name2;
        if (name1 instanceof CMakeArgument) {
            firstLiteral = ((CMakeArgument)name1).getCMakeLiteral();
        }
        if (name2 instanceof CMakeArgument) {
            secondLiteral = ((CMakeArgument)name2).getCMakeLiteral();
        }
        if (secondLiteral == null) {
            return firstLiteral == null;
        }
        String definitionNameCandidate = secondLiteral.getText();
        return CMakeCommandReferenceHelper.commandNamesEqualByText(firstLiteral, definitionNameCandidate);
    }

    public static boolean commandNamesEqualByText(@Nullable PsiElement element, @Nullable String definitionNameCandidate) {
        if (element == null) {
            return definitionNameCandidate == null;
        }
        PsiElement literal = element;
        if (element instanceof CMakeArgument) {
            literal = ((CMakeArgument)element).getCMakeLiteral();
        }
        return literal != null && literal.getText().equalsIgnoreCase(definitionNameCandidate);
    }

    public static boolean isCommandCall(@Nullable PsiElement probableCommandName) {
        return probableCommandName instanceof CMakeCommandNameMixin;
    }

    public static boolean isCommandDefinition(@Nullable PsiElement possibleCommandDefinition) {
        if (!CMakeCommandReferenceHelper.isArgument(possibleCommandDefinition)) {
            return false;
        }
        if (possibleCommandDefinition instanceof CMakeArgument && ((CMakeArgument)possibleCommandDefinition).isCommandDefinitionName()) {
            return true;
        }
        return possibleCommandDefinition instanceof CMakeLiteral && ((CMakeArgument)possibleCommandDefinition.getParent()).isCommandDefinitionName();
    }

    public static boolean isEndCommandDefinition(@Nullable PsiElement possibleEndCommandDefinition) {
        return CMakeCommandReferenceHelper.isEndCommandDefinition(possibleEndCommandDefinition, null);
    }

    public static boolean isEndCommandDefinition(@Nullable PsiElement possibleEndCommandDefinition, @Nullable String definitionNameCandidate) {
        if (!CMakeCommandReferenceHelper.isArgument(possibleEndCommandDefinition)) {
            return false;
        }
        if (possibleEndCommandDefinition instanceof CMakeArgument && ((CMakeArgument)possibleEndCommandDefinition).isEndCommandDefinitionName(definitionNameCandidate)) {
            return true;
        }
        return possibleEndCommandDefinition instanceof CMakeLiteral && ((CMakeArgument)possibleEndCommandDefinition.getParent()).isEndCommandDefinitionName(definitionNameCandidate);
    }
}

