/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CMakeRenameUtils {
    public static void renameArgument(@NotNull Project project2, @NotNull String newName, @NotNull ASTNode parentToRename) {
        CMakeArgument newArgument = CMakeElementFactory.createArgument(project2, newName);
        CMakeRenameUtils.renameNode(parentToRename, newArgument.getLiteralNotNull().getNode(), CMakeTokenTypes.C_MAKE_LITERAL);
    }

    public static void renameCommandCall(@NotNull Project project2, @NotNull String newName, @NotNull ASTNode parentToRename) {
        CMakeCommandName newCommandName = CMakeElementFactory.createCommandName(project2, newName);
        CMakeRenameUtils.renameNode(parentToRename, newCommandName.getFirstChild().getNode(), CMakeElementTypes.COMMAND_ELEMENTS.getTypes());
    }

    private static void renameNode(@NotNull ASTNode parentToSearch, ASTNode replacement, IElementType ... nodeTypesToSearch) {
        for (IElementType nodeTypeToSearch : nodeTypesToSearch) {
            ASTNode nameNode = parentToSearch.findChildByType(nodeTypeToSearch);
            if (nameNode == null) continue;
            parentToSearch.replaceChild(nameNode, replacement);
            return;
        }
    }
}

