/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeDefinitionsSearch
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        PsiElement queryParametersElement = queryParameters.getElement();
        ReadAction.run(() -> {
            PsiReference reference = CMakeDefinitionsSearch.findReference(queryParametersElement);
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResults;
                for (ResolveResult resolveResult : resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement resolvedElement = resolveResult.getElement();
                    if (resolvedElement == null) continue;
                    consumer.process((Object)resolvedElement.getParent().getParent());
                }
            }
        });
    }

    @Nullable
    private static PsiReference findReference(@NotNull PsiElement queryParametersElement) {
        PsiReference reference = null;
        if (queryParametersElement instanceof CMakeCommandName) {
            reference = queryParametersElement.getParent().getReference();
        } else if (queryParametersElement instanceof CMakeArgument) {
            reference = queryParametersElement.getReference();
        }
        return reference;
    }
}

