/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.atttributes;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AttributeQueryHistory {
    private final List<Node> rootNodes = new ArrayList<Node>();
    private final Map<Node, ArrayList<Node>> parentToKids = new WeakHashMap<Node, ArrayList<Node>>();
    private final Map<Node, Node> kidToParent = new WeakHashMap<Node, Node>();
    private final List<INodeSelectionListener> nodeSelectionListeners = new ArrayList<INodeSelectionListener>();
    private final List<Attribute[]> attributesHistory = new ArrayList<Attribute[]>();
    private int attributeIndex = -1;
    private Node currentNode;
    private Attribute currentAttribtue;

    public boolean isNodeCompatible(Node node, String query, Attribute[] kids) {
        if (!node.query.startsWith(query)) {
            return false;
        }
        if (!this.parentToKids.containsKey(node) || kids.length == 0) {
            return true;
        }
        Node[] children = this.getTreeChildren(node);
        if (children.length == 0 || !children[0].isAttrNode) {
            return true;
        }
        return children[0].attribute.getType().getName().equals(kids[0].getType().getName());
    }

    public Attribute[] getAttributes() {
        if (this.attributesHistory.isEmpty()) {
            return null;
        }
        return this.attributesHistory.get(this.attributeIndex);
    }

    public Attribute getCurrentAttribute() {
        if (this.currentAttribtue == null) {
            Attribute[] attributes = this.getAttributes();
            return attributes == null || attributes.length == 0 ? null : attributes[0];
        }
        return this.currentAttribtue;
    }

    public void setCurrentAttribute(Attribute attribute) {
        this.currentAttribtue = attribute;
    }

    private void doSetAttributes(Attribute[] attributes) {
        ++this.attributeIndex;
        if (this.attributesHistory.size() > this.attributeIndex) {
            this.attributesHistory.subList(this.attributeIndex, this.attributesHistory.size()).clear();
        }
        this.attributesHistory.add(attributes);
    }

    private Node addRootAttributes(Attribute[] attributes) {
        for (int i = this.rootNodes.size() - 1; i >= 0 && this.parentToKids.get(this.rootNodes.get(i)) == null; --i) {
            this.rootNodes.remove(i);
        }
        for (Attribute attribute : attributes) {
            this.currentNode = new Node(attribute, null, true);
            this.rootNodes.add(this.currentNode);
        }
        return this.currentNode;
    }

    public void setAttributes(Attribute[] attributes) {
        this.doSetAttributes(attributes);
        this.addRootAttributes(attributes);
    }

    public void setAttribute(Attribute attribute) {
        this.doSetAttributes(new Attribute[]{attribute});
        this.addRootAttributes(new Attribute[]{attribute});
    }

    public Node setAttribute(String query, Attribute[] attributes, Attribute[][] auxAttributes, long numOfAttributes, Attribute attribute) {
        if (attribute != null) {
            this.doSetAttributes(new Attribute[]{attribute});
        }
        if (query != null && this.currentNode != null) {
            List availableQueries = this.parentToKids.get(this.currentNode);
            if (availableQueries != null) {
                for (Object availableQuery : availableQueries) {
                    Node queryNode = (Node)availableQuery;
                    if (queryNode.isAttrNode || !this.isNodeCompatible(queryNode, query, attributes)) continue;
                    if (attribute == null) {
                        return queryNode;
                    }
                    List kids = this.parentToKids.get(queryNode);
                    if (kids != null) {
                        for (Object kid1 : kids) {
                            Node kid = (Node)kid1;
                            if (!kid.isAttrNode || !kid.attribute.equals(attribute)) continue;
                            this.currentNode = kid;
                            return kid;
                        }
                    }
                    this.currentNode = new Node(attribute, null, true);
                    this.addTreeChild(queryNode, this.currentNode);
                    return this.currentNode;
                }
            }
            Node child = new Node(null, query + " (" + numOfAttributes + ")", false);
            this.addTreeChild(this.currentNode, child);
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    Node grandChild = new Node(attributes[i], null, true);
                    this.addTreeChild(child, grandChild);
                    if (auxAttributes != null) {
                        for (int j = 0; j < auxAttributes[i].length; ++j) {
                            this.addTreeChild(grandChild, new Node(auxAttributes[i][j], null, true));
                        }
                    }
                    if (!attributes[i].equals(attribute)) continue;
                    this.currentNode = grandChild;
                }
            } else if (attribute != null) {
                this.currentNode = new Node(attribute, null, true);
                this.addTreeChild(child, this.currentNode);
            }
            return attribute != null ? this.currentNode : child;
        }
        if (attribute != null) {
            return this.addRootAttributes(new Attribute[]{attribute});
        }
        return null;
    }

    public void addNodeSelectionListener(INodeSelectionListener listener) {
        this.nodeSelectionListeners.add(listener);
    }

    public void attributeSelected(Attribute attribute) {
        for (int i = this.rootNodes.size() - 1; i >= 0; --i) {
            Node node = this.rootNodes.get(i);
            if (!node.isAttrNode || !node.attribute.equals(attribute)) continue;
            this.currentNode = node;
            for (INodeSelectionListener nodeSelectionListener : this.nodeSelectionListeners) {
                nodeSelectionListener.nodeSelected(node);
            }
            break;
        }
    }

    public void clearHistory() {
        for (int i = this.rootNodes.size() - 2; i >= 0; --i) {
            this.rootNodes.remove(i);
        }
    }

    public void clearAttributes() {
        this.attributesHistory.clear();
        this.attributeIndex = -1;
        this.rootNodes.clear();
    }

    public void back() {
        --this.attributeIndex;
        for (int i = 0; i < 2; ++i) {
            if (this.currentNode == null) continue;
            this.currentNode = this.kidToParent.get(this.currentNode);
        }
    }

    public void forward() {
        ++this.attributeIndex;
        List kids = this.parentToKids.get(this.currentNode);
        if (kids == null) {
            return;
        }
        for (Object kid1 : kids) {
            List grandKids;
            Node kid = (Node)kid1;
            if (kid.isAttrNode || (grandKids = (List)this.parentToKids.get(kid)) == null) continue;
            for (Object grandKid1 : grandKids) {
                Node grandKid = (Node)grandKid1;
                if (!grandKid.isAttrNode || !ArrayHelper.containsElement(this.attributesHistory.get(this.attributeIndex), grandKid.attribute)) continue;
                this.currentNode = grandKid;
                return;
            }
        }
    }

    public boolean backAvailable() {
        return this.attributeIndex > 0;
    }

    public boolean forwardAvailable() {
        return this.attributeIndex < this.attributesHistory.size() - 1;
    }

    public Node[] getTreeRootNodes() {
        return (Node[])ArrayHelper.castArray(this.rootNodes.toArray(), Node.class);
    }

    public Node[] getTreeChildren(Node parent) {
        List kids = this.parentToKids.get(parent);
        if (kids != null) {
            return (Node[])ArrayHelper.castArray(kids.toArray(), Node.class);
        }
        return new Node[0];
    }

    public Node getTreeParent(Node child) {
        return this.kidToParent.get(child);
    }

    public void addTreeChild(Node parent, Node child) {
        if (!this.parentToKids.containsKey(parent)) {
            this.parentToKids.put(parent, new ArrayList());
        }
        this.parentToKids.get(parent).add(child);
        this.kidToParent.put(child, parent);
    }

    public Node removeTreeNode(Node node) {
        List nodes = this.kidToParent.containsKey(node) ? (List)this.parentToKids.get(this.kidToParent.get(node)) : this.rootNodes;
        int index = nodes.indexOf(node);
        if (this.currentNode == node) {
            if (index < this.rootNodes.size() - 1) {
                this.currentNode = (Node)nodes.get(index + 1);
            } else if (index > 0) {
                this.currentNode = (Node)nodes.get(index - 1);
            }
        }
        nodes.remove(index);
        return this.currentNode;
    }

    public void removeAllTreeChildren(Node parent) {
        this.parentToKids.remove(parent);
    }

    public void nodeSelected(Node node) {
        if (node.isAttrNode) {
            this.currentNode = node;
            this.doSetAttributes(new Attribute[]{node.attribute});
        }
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public static interface INodeSelectionListener {
        public void nodeSelected(Node var1);
    }

    public static class Node {
        public Attribute attribute;
        public String query;
        public String domainType;
        public boolean isAttrNode;

        public Node(Attribute attribute, String query, boolean isAttrNode) {
            this.attribute = attribute;
            this.query = query;
            this.isAttrNode = isAttrNode;
        }
    }
}

