/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.dump;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.relations.dump.Dump;
import com.jetbrains.sourceglider.relations.dump.RelationHandle;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.symtable.KnownDomainTypes;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.symtable.WrongAttributeException;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelationDump
implements Dump,
Serializable {
    private static final long serialVersionUID = -8370122741507692261L;
    private final ManagerInstancesProvider managerInstancesProvider;
    private List<String> relnames;
    private List<RelationHandleImpl> relations;
    private SymbolTable symTab;
    private IRelationsManager relationsManager;
    private RelationDump commonDump;
    private String compilationUnit;

    public RelationDump(ManagerInstancesProvider provider2) {
        this.symTab = provider2.getSymbolTable();
        this.relations = new ArrayList<RelationHandleImpl>();
        this.relnames = new ArrayList<String>();
        this.managerInstancesProvider = provider2;
        this.relationsManager = this.managerInstancesProvider.getRelationsManager();
    }

    public RelationDump(String compilationUnit, RelationDump commonDump, ManagerInstancesProvider provider2) {
        this(provider2);
        this.compilationUnit = compilationUnit;
        this.commonDump = commonDump;
    }

    public List<String> getRelnames() {
        return this.relnames;
    }

    @Override
    public RelationHandle addRelation(RelationSignature signature) {
        RelationHandleImpl relation = new RelationHandleImpl(signature, this.relations.size());
        this.relations.add(relation);
        this.relnames.add(signature.getName());
        if (this.commonDump != null && this.commonDump.relations.size() < this.relations.size()) {
            this.commonDump.relations.add(relation);
            this.commonDump.relnames.add(signature.getName());
        }
        return relation;
    }

    public void unite(RelationDump dump, ThreadCallback threadCallback) {
        if (this.relations.size() == 0) {
            this.relnames = dump.relnames;
            this.relations = new ArrayList<RelationHandleImpl>();
            for (int i = 0; i < dump.relations.size(); ++i) {
                this.relations.add(new RelationHandleImpl(dump.relations.get(i), i));
            }
            return;
        }
        if (this.relations.size() != dump.relations.size()) {
            throw new RuntimeException(Messages.getString(RelationDump.class.getName() + "-0"));
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            IRelation rel1 = this.relations.get((int)i).relation;
            IRelation rel2 = dump.relations.get((int)i).relation;
            this.relations.get((int)i).relation = rel1.unite(rel2, threadCallback);
            rel1.kill();
        }
    }

    public void copyToRepository(RelationsRepository relationsRepository) {
        Iterator<RelationHandleImpl> iterator2 = this.relations.iterator();
        while (iterator2.hasNext()) {
            RelationHandleImpl relation;
            RelationHandleImpl handle = relation = iterator2.next();
            relationsRepository.addRelation(handle.getName(), handle.relation);
        }
    }

    public RelationDump incrementalize(RelationDump addDump, RelationDump subDump, RelationsRepository relationsRepository) {
        for (int i = 0; i < this.relations.size(); ++i) {
            RelationHandleImpl base = this.relations.get(i);
            IRelation baseRelation = base.relation;
            IRelation addRelation = addDump.relations.isEmpty() ? this.relationsManager.makeEmptyRelation(baseRelation.getDomains()) : addDump.relations.get((int)i).relation;
            IRelation subRelation = subDump.relations.isEmpty() ? this.relationsManager.makeEmptyRelation(baseRelation.getDomains()) : subDump.relations.get((int)i).relation;
            IRelation relation = this.relationsManager.makeSubIncrementalRelation(baseRelation, addRelation, subRelation, null);
            this.relations.set(i, new RelationHandleImpl(base.getName(), relation, i));
        }
        return this;
    }

    public IRelation[] getSerializeableRelations() {
        IRelation[] rels = new IRelation[this.relations.size()];
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = this.relations.get((int)i).relation;
        }
        return rels;
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeObject(this.relnames);
        for (RelationHandleImpl relation : this.relations) {
            out.writeObject(relation.getName());
        }
    }

    public static RelationDump deserialize(ObjectInputStream in, RelationDump commonDump, IRelation[] relationsBuffer, int pos, ManagerInstancesProvider provider2) throws IOException, ClassNotFoundException {
        RelationDump result = new RelationDump(null, commonDump, provider2);
        result.relnames = (List)in.readObject();
        for (int i = 0; i < result.relnames.size(); ++i) {
            String name2 = (String)in.readObject();
            List<RelationHandleImpl> list = result.relations;
            RelationDump relationDump = result;
            relationDump.getClass();
            list.add(relationDump.new RelationHandleImpl(name2, relationsBuffer[pos++], i));
        }
        return result;
    }

    private class RelationHandleImpl
    extends RelationHandle {
        IRelation relation;
        DomainType[] types;
        int index;

        RelationHandleImpl(RelationSignature signature, int index) {
            super(signature.getName());
            this.index = index;
            this.types = signature.getTypes();
            this.relation = RelationDump.this.relationsManager.makeEmptyRelation(this.types);
        }

        RelationHandleImpl(RelationHandleImpl handle, int index) {
            super(handle.getName());
            this.index = index;
            this.types = handle.types;
            this.relation = handle.relation;
        }

        RelationHandleImpl(String name2, IRelation relation, int index) {
            super(name2);
            this.index = index;
            this.relation = relation;
            this.types = relation.getDomainTypes();
        }

        @Override
        public RelationHandle getCommon() {
            return (RelationHandle)RelationDump.this.commonDump.relations.get(this.index);
        }

        @Override
        public void addTuple(String[] elems) {
            if (elems.length != this.types.length) {
                throw new RuntimeException(Messages.getString(RelationDump.class.getName() + "-1"));
            }
            try {
                int[] attrs = new int[elems.length];
                for (int i = 0; i < attrs.length; ++i) {
                    attrs[i] = !this.types[i].getName().equals(KnownDomainTypes.DOM_BIG_INTEGERS) ? RelationDump.this.symTab.getAttributeInt(this.types[i], elems[i]) : Integer.parseInt(elems[i]);
                }
                IRelation oldRelation = this.relation;
                this.relation = this.relation.addTuple(attrs);
                oldRelation.kill();
            }
            catch (WrongAttributeException e) {
                RelationDump.this.managerInstancesProvider.showWrongAttributeWarning(e, RelationDump.this.compilationUnit);
            }
        }
    }
}

