/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.dump;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.relations.dump.RelationDump;
import com.jetbrains.sourceglider.relations.dump.RelationHandle;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.PrettyName;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RelationsTextDump {
    private static final String SIGNATURE_KEYWORD = "$signature";
    private static final String TUPLE_KEYWORD = "$tuple";
    private final ManagerInstancesProvider managerInstancesProvider;
    private final UICallback uiCallback;
    private String dumpPath;
    private Map<String, RelationSignature> signatures;

    public RelationsTextDump(String dumpPath, ManagerInstancesProvider provider2) {
        this.dumpPath = dumpPath;
        this.managerInstancesProvider = provider2;
        this.uiCallback = provider2.getUICallback();
    }

    public RelationSignature[] getSignatures() {
        return (RelationSignature[])ArrayHelper.castArray(this.signatures.values().toArray(), RelationSignature.class);
    }

    public void writeDump(String[] relations, ThreadCallback threadCallback) throws Exception {
        FileOutputStream fos = new FileOutputStream(this.dumpPath);
        PrintStream out = new PrintStream(new BufferedOutputStream(fos));
        for (int i = 0; i < relations.length; ++i) {
            Attribute[][] tuples;
            threadCallback.informProgress(i, relations.length, Messages.getString(RelationsTextDump.class.getName() + "-0") + relations[i]);
            if (threadCallback.checkCancelled()) break;
            IRelation relation = this.managerInstancesProvider.getRelationsRepository().getRelation(relations[i]);
            out.print("$signature " + relations[i] + ":");
            for (int j = 0; j < relation.getDomains().length; ++j) {
                out.print("\r\n" + relation.getDomainType(j).getName());
            }
            out.println();
            for (Attribute[] tuple : tuples = relation.getAttributes(this.managerInstancesProvider.getSymbolTable())) {
                out.print("$tuple " + relations[i] + ":");
                for (Attribute attr : tuple) {
                    out.print("\r\n" + attr.getPrettyName().getMarked());
                }
                out.println();
            }
        }
        out.close();
        fos.close();
    }

    public void readDomainsFromDump(ThreadCallback threadCallback, final SymbolTable symbolTable) {
        this.signatures = new HashMap<String, RelationSignature>();
        this.passFile(new LineProcessor(){

            @Override
            public void processLine(String keyWord, String name2, String[] tokens) {
                if (tokens.length == 0) {
                    RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-1") + RelationsTextDump.this.dumpPath + "\"", true);
                    return;
                }
                if (keyWord.equals(RelationsTextDump.SIGNATURE_KEYWORD)) {
                    DomainType[] types = new DomainType[tokens.length];
                    for (int i = 0; i < types.length; ++i) {
                        types[i] = symbolTable.getDomainType(tokens[i]);
                        if (types[i] != null) continue;
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-2") + tokens[i] + Messages.getString(RelationsTextDump.class.getName() + "-3") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    RelationsTextDump.this.signatures.put(name2, new RelationSignature(name2, types));
                } else if (keyWord.equals(RelationsTextDump.TUPLE_KEYWORD)) {
                    RelationSignature signature = (RelationSignature)RelationsTextDump.this.signatures.get(name2);
                    if (signature == null) {
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-4") + name2 + Messages.getString(RelationsTextDump.class.getName() + "-5") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    if (signature.getTypes().length != tokens.length) {
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-6") + name2 + Messages.getString(RelationsTextDump.class.getName() + "-7") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    for (int i = 0; i < signature.getTypes().length; ++i) {
                        symbolTable.addAttribute(new Attribute(tokens[i], signature.getType(i), null, -1, -1, new PrettyName(tokens[i])));
                    }
                }
            }
        }, threadCallback);
    }

    public void readRelationsFromDump(ThreadCallback threadCallback) {
        final RelationDump dump = new RelationDump(this.managerInstancesProvider);
        final HashMap handles = new HashMap();
        this.passFile(new LineProcessor(){

            @Override
            public void processLine(String keyWord, String name2, String[] tokens) {
                if (keyWord.equals(RelationsTextDump.TUPLE_KEYWORD)) {
                    if (!handles.containsKey(name2)) {
                        RelationSignature signature = (RelationSignature)RelationsTextDump.this.signatures.get(name2);
                        handles.put(name2, dump.addRelation(signature));
                    }
                    RelationHandle handle = (RelationHandle)handles.get(name2);
                    handle.addTuple(tokens);
                }
            }
        }, threadCallback);
        dump.copyToRepository(this.managerInstancesProvider.getRelationsRepository());
    }

    private void passFile(LineProcessor lineProcessor, ThreadCallback threadCallback) {
        try {
            String line;
            String[] keywords = new String[]{SIGNATURE_KEYWORD, TUPLE_KEYWORD};
            BufferedReader in = new BufferedReader(new FileReader(this.dumpPath));
            ArrayList<String> tuple = null;
            String keyWord = null;
            String name2 = null;
            while (!threadCallback.checkCancelled() && (line = in.readLine()) != null) {
                int i;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                for (i = 0; i < keywords.length; ++i) {
                    if (!line.startsWith(keywords[i])) continue;
                    if (keyWord != null) {
                        lineProcessor.processLine(keyWord, name2, ArrayHelper.castStringArray(tuple.toArray()));
                    }
                    keyWord = keywords[i];
                    name2 = line.substring(keywords[i].length() + 1, line.length() - 1);
                    tuple = new ArrayList<String>();
                    break;
                }
                if (i != keywords.length) continue;
                tuple.add(line);
            }
            if (keyWord != null) {
                lineProcessor.processLine(keyWord, name2, ArrayHelper.castStringArray(tuple.toArray()));
            }
            in.close();
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-8") + this.dumpPath + "\"", e, true);
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1, String var2, String[] var3);
    }
}

