/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.plain;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.plain.PlainRelation;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlainRelationsManager
implements IRelationsManager {
    SymbolTable symbolTable;
    IBDDManager bddManager;

    @Override
    public void init(IBDDManager bddManager, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.bddManager = bddManager;
    }

    @Override
    public IRelation makeRepositoryRelation(IRelation relation, String relname) {
        ((PlainRelation)relation).isPersistent = true;
        return relation;
    }

    @Override
    public IRelation makeSubIncrementalRelation(IRelation base, IRelation add, IRelation sub, ThreadCallback threadCallback) {
        return base.subtract(sub, threadCallback).unsafeUnite(add, threadCallback);
    }

    @Override
    public IRelation makeEmptyRelation(Domain[] domains) {
        return new PlainRelation(this, domains);
    }

    @Override
    public IRelation makeEmptyRelation(DomainType[] types) {
        return new PlainRelation(this, types);
    }

    @Override
    public IRelation makeEmptyRelation(Domain[] domains, boolean isFull) {
        return new PlainRelation(this, domains, isFull);
    }

    @Override
    public IRelation makeSingleTuple(Domain domain, int value) {
        return new PlainRelation(this, this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), value), new Domain[]{domain});
    }

    @Override
    public IRelation makeSingleTuple(DomainType type, int value) {
        Domain domain = type.getDomain(0);
        return new PlainRelation(this, this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), value), new Domain[]{domain});
    }

    @Override
    public IRelation makeRegExprSet(Domain domain, String regexpr, ThreadCallback threadCallback) {
        SymbolTable symTable = this.symbolTable;
        DomainType type = domain.getType();
        Pattern pattern = Pattern.compile(regexpr);
        IBDD node = this.bddManager.getZero();
        for (int i = 0; i < type.getNumOfAttrs(); ++i) {
            Matcher matcher = pattern.matcher(symTable.getAttribute(type, i).getKey());
            if (!matcher.matches()) continue;
            IBDD tuple = this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), i);
            IBDD oldNode = node;
            node = node.unite(tuple, threadCallback);
            tuple.decRefCount();
            oldNode.decRefCount();
        }
        return new PlainRelation(this, node, new Domain[]{domain});
    }

    @Override
    public IRelation makeEqual(Domain domain1, Domain domain2, ThreadCallback threadCallback) {
        if (!domain1.getType().equals(domain2.getType())) {
            throw new RuntimeException(Messages.getString(PlainRelationsManager.class.getName() + "-0"));
        }
        IBDD node = this.bddManager.getZero();
        DomainType type = domain1.getType();
        for (int i = 0; i < type.getNumOfAttrs(); ++i) {
            IBDD pair2 = this.bddManager.makeSingleTuple(domain1.getFirstVar(), domain1.size(), i);
            IBDD tuple = this.bddManager.makeSingleTuple(domain2.getFirstVar(), domain2.size(), i);
            IBDD oldPair = pair2;
            pair2 = pair2.intersect(tuple, threadCallback);
            node = node.unite(pair2, threadCallback);
            oldPair.decRefCount();
            pair2.decRefCount();
            tuple.decRefCount();
        }
        return new PlainRelation(this, node, new Domain[]{domain1, domain2});
    }

    @Override
    public void serialize(ObjectOutputStream stream, IRelation[] relations, ThreadCallback threadCallback, double progressPart, String message) throws IOException {
        IBDD[] nodes = new IBDD[relations.length];
        for (int i = 0; i < relations.length; ++i) {
            nodes[i] = ((PlainRelation)relations[i]).root;
        }
        this.bddManager.serialize(stream, nodes, threadCallback, progressPart, message);
        for (IRelation relation : relations) {
            PlainRelation rel = (PlainRelation)relation;
            String[] typeNames = new String[rel.domains.length];
            for (int j = 0; j < rel.domains.length; ++j) {
                typeNames[j] = rel.domains[j].getType().getName();
            }
            stream.writeObject(typeNames);
        }
    }

    @Override
    public IRelation[] deserialize(ObjectInputStream stream, ThreadCallback threadCallback, double progressPart, String message) throws IOException, ClassNotFoundException {
        IBDD[] nodes = this.bddManager.deserialize(stream, threadCallback, progressPart, message);
        IRelation[] result = new IRelation[nodes.length];
        for (int i = 0; i < result.length; ++i) {
            String[] typeNames = (String[])stream.readObject();
            DomainType[] types = new DomainType[typeNames.length];
            for (int j = 0; j < types.length; ++j) {
                types[j] = this.symbolTable.getDomainType(typeNames[j]);
            }
            result[i] = new PlainRelation(this, nodes[i], DomainType.getCorrespondingDomains(types));
        }
        return result;
    }
}

