/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.repositories;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.HashMap;

public class MemoryRelationsRepository
extends RelationsRepository {
    private final UICallback uiCallback;
    private HashMap<String, IRelation> nameToRelationMap = new HashMap();
    protected IRelationsManager relationsManager;

    public MemoryRelationsRepository(IRelationsManager relationsManager, UICallback callback) {
        this.relationsManager = relationsManager;
        this.uiCallback = callback;
    }

    @Override
    public void clear() {
        this.nameToRelationMap = new HashMap();
    }

    @Override
    public String[] getAvailableRelations() {
        return ArrayHelper.castStringArray(this.nameToRelationMap.keySet().toArray());
    }

    @Override
    public boolean containsRelation(String name2) {
        return this.nameToRelationMap.containsKey(name2);
    }

    @Override
    public IRelation getRelation(String name2) {
        return this.relationsManager.makeRepositoryRelation(this.nameToRelationMap.get(name2), name2);
    }

    @Override
    public DomainType[] getDomainTypes(String name2) {
        return this.nameToRelationMap.get(name2).getDomainTypes();
    }

    @Override
    public void addRelation(String name2, IRelation relation) {
        this.nameToRelationMap.put(name2, relation);
        super.addRelation(name2, relation);
    }

    @Override
    public void deleteRelation(String name2) {
        if (!this.nameToRelationMap.containsKey(name2)) {
            this.uiCallback.showError(Messages.getString(MemoryRelationsRepository.class.getName() + "-0") + name2, false);
        }
        this.nameToRelationMap.remove(name2);
        super.deleteRelation(name2);
    }
}

