/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.util.HashMap;
import java.util.Map;

public class RuntimeVariablesManager {
    private RelationsRepository relationsRepository;
    private RelationSignature[] outputRelations;
    private HashMap<String, IRelation> relations = new HashMap();
    private HashMap<String, Domain> domains = new HashMap();
    private HashMap variables = new HashMap();

    public RuntimeVariablesManager(RelationsRepository relationsRepository, Map options, VariablesManager staticManager, IRelationsManager relationsManager) {
        this.relationsRepository = relationsRepository;
        this.outputRelations = staticManager.getOutputRelations();
        for (String name2 : staticManager.getVariables()) {
            if (staticManager.isOption(name2)) {
                if (options.containsKey(name2)) {
                    this.variables.put(name2, options.get(name2));
                    continue;
                }
                this.variables.put(name2, staticManager.getDefaultOptionValue(name2));
                continue;
            }
            this.variables.put(name2, new Integer(0));
        }
        for (int i = 0; i < staticManager.getInputRelations().length; ++i) {
            String name2;
            name2 = staticManager.getInputRelations()[i].getName();
            IRelation relation = relationsRepository.getRelation(name2);
            if (relation == null) {
                throw new RuntimeException(Messages.getString(RuntimeVariablesManager.class.getName() + "-0") + name2 + "\"");
            }
            this.relations.put(name2, relation);
        }
        for (RelationSignature outputRelation : this.outputRelations) {
            String name3 = outputRelation.getName();
            if (this.relations.containsKey(name3)) continue;
            IRelation relation = relationsManager.makeEmptyRelation(staticManager.getRelation(name3));
            this.relations.put(name3, relation);
        }
        for (int i = 0; i < staticManager.getTempRelations().length; ++i) {
            String name4 = staticManager.getTempRelations()[i].getName();
            if (this.relations.containsKey(name4)) continue;
            IRelation relation = relationsManager.makeEmptyRelation(staticManager.getRelation(name4));
            this.relations.put(name4, relation);
        }
    }

    public void storeOutputRelations(ThreadCallback threadCallback) {
        for (RelationSignature outputRelation : this.outputRelations) {
            String name2 = outputRelation.getName();
            IRelation relation = this.relations.get(name2);
            relation = relation.fastRename(DomainType.getCorrespondingDomains(relation.getDomainTypes()), threadCallback);
            this.relationsRepository.addRelation(name2, relation);
        }
    }

    public IRelation getRelation(String name2) {
        return this.relations.get(name2);
    }

    public void storeRelation(String name2, IRelation relation) {
        this.relations.put(name2, relation);
    }

    public int getVariable(String name2) {
        return (Integer)this.variables.get(name2);
    }

    public void storeVariable(String name2, int value) {
        this.variables.put(name2, new Integer(value));
    }

    public Domain getDomain(String name2) {
        return this.domains.get(name2);
    }

    public void storeDomain(String name2, Domain domain) {
        this.domains.put(name2, domain);
    }

    public void removeDomain(String name2) {
        this.domains.remove(name2);
    }
}

