/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class StmtPrint
extends Stmt {
    public static final int RELATION = 0;
    public static final int RELVAR = 1;
    public static final int STRING = 2;
    public static final int INTEGER = 3;
    public static final int BOOLEAN = 4;
    public static final int REGEXP = 5;
    public static final int SIZE = 6;
    private List printValues;
    private List<Integer> printTypes;

    public StmtPrint(List<Integer> printTypes, List printValues, Context context) {
        super(context);
        this.printValues = printValues;
        this.printTypes = printTypes;
        for (Object printValue : printValues) {
            int j;
            if (!(printValue instanceof RelationPrintBundle)) continue;
            RelationPrintBundle bundle = (RelationPrintBundle)printValue;
            bundle.domainConstraints = new DomainConstraint[bundle.domainNames.size()][];
            HashMap<String, List> constraintsMap = new HashMap<String, List>();
            ArrayList[] vectors = new ArrayList[bundle.domainNames.size()];
            for (j = 0; j < vectors.length; ++j) {
                vectors[j] = new ArrayList();
                constraintsMap.put(bundle.domainNames.get(j), vectors[j]);
            }
            bundle.expr.collectDomainConstraints(constraintsMap, context.variablesManager);
            for (j = 0; j < vectors.length; ++j) {
                bundle.domainConstraints[j] = (DomainConstraint[])ArrayHelper.castArray(vectors[j].toArray(), DomainConstraint.class);
            }
        }
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        if (threadCallback.checkCancelled()) {
            return;
        }
        for (int i = 0; i < this.printTypes.size(); ++i) {
            int j;
            int type = this.printTypes.get(i);
            Object value = this.printValues.get(i);
            if (type == 2) {
                uiInstancesProvider.getConsole().print((String)value);
                continue;
            }
            if (type == 1) {
                IRelation relation = variablesManager.getRelation((String)value);
                uiInstancesProvider.getRelationsConsole().print(relation, (String)value, symbolTable);
                continue;
            }
            if (type == 6) {
                IRelation relation = variablesManager.getRelation((String)value);
                uiInstancesProvider.getConsole().print(Messages.getString(StmtPrint.class.getName() + "-0") + value + Messages.getString(StmtPrint.class.getName() + "-1") + relation.getNumOfTuples());
                continue;
            }
            if (type == 0) {
                int j2;
                RelationPrintBundle bundle = (RelationPrintBundle)value;
                Domain[] domains = new Domain[bundle.domainNames.size()];
                for (int j3 = 0; j3 < bundle.domainNames.size(); ++j3) {
                    String name2 = bundle.domainNames.get(j3);
                    DomainType domType = bundle.domainTypes.get(j3) instanceof DomainType ? (DomainType)bundle.domainTypes.get(j3) : ((DomainTypeReference)bundle.domainTypes.get(j3)).resolve(variablesManager);
                    domains[j3] = domainsPool.computeBestDomain(variablesManager, name2, domType, bundle.domainConstraints[j3]);
                    domainsPool.pushDomain(domains[j3]);
                    variablesManager.storeDomain(name2, domains[j3]);
                }
                HashMap<String, Integer> map2 = new HashMap<String, Integer>();
                int len = 0;
                int[] sortPermutation = new int[domains.length];
                for (j2 = 0; j2 < domains.length; ++j2) {
                    map2.put(bundle.domainNames.get(j2), new Integer(j2));
                }
                for (j2 = 0; j2 < bundle.sortOrder.size(); ++j2) {
                    String domain = bundle.sortOrder.get(j2);
                    sortPermutation[len++] = (Integer)map2.get(domain);
                    map2.remove(domain);
                }
                for (j2 = 0; j2 < domains.length; ++j2) {
                    if (!map2.containsKey(bundle.domainNames.get(j2))) continue;
                    sortPermutation[len++] = j2;
                }
                IRelation relation = bundle.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager).reorderDomains(domains);
                uiInstancesProvider.getRelationsConsole().print(relation, Messages.getString(StmtPrint.class.getName() + "-2"), bundle.maxTuples, sortPermutation, symbolTable);
                for (j = bundle.domainNames.size() - 1; j >= 0; --j) {
                    variablesManager.removeDomain(bundle.domainNames.get(j));
                    domainsPool.popDomain(domains[j]);
                }
                domainsPool.assertEmpty();
                continue;
            }
            if (type == 5) {
                DomainType[] types;
                uiInstancesProvider.getConsole().println(Messages.getString(StmtPrint.class.getName() + "-3") + value + "\"");
                Pattern pattern = Pattern.compile((String)value);
                for (DomainType domType : types = symbolTable.getAvailableDomainTypes()) {
                    for (j = 0; j < domType.getNumOfAttrs(); ++j) {
                        Attribute attribute = symbolTable.getAttribute(domType, j);
                        if (!pattern.matcher(attribute.getKey()).matches()) continue;
                        uiInstancesProvider.getConsole().print(domType.getName() + ": ");
                        if (attribute.isRevealable()) {
                            uiInstancesProvider.getConsole().printAttribute(attribute);
                        } else {
                            uiInstancesProvider.getConsole().print(attribute.getKey() + ": \"" + attribute.getPrettyName() + "\"");
                        }
                        uiInstancesProvider.getConsole().println();
                    }
                }
                continue;
            }
            int numValue = variablesManager.getVariable((String)value);
            if (type == 3) {
                uiInstancesProvider.getConsole().print(Integer.toString(numValue));
                continue;
            }
            uiInstancesProvider.getConsole().print(Boolean.toString(numValue == 1));
        }
    }

    public static class RelationPrintBundle {
        public int maxTuples = -1;
        public RelExpr expr;
        public List<String> domainNames = new ArrayList<String>();
        public List domainTypes = new ArrayList();
        public List<String> sortOrder = new ArrayList<String>();
        public DomainConstraint[][] domainConstraints;
    }
}

