/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui;

import com.jetbrains.sourceglider.utils.PrettyName;

public class PrettyNameFormatter {
    private static final String CUT_SEQUENCE = "...";
    private static final int DEFAULT_MAX_CHARS_COUNT = 25;
    private static final int MIN_SUFFIX_LENGTH = 4;

    public PrettyName normalize(PrettyName prettyName) {
        String text = prettyName.getText();
        int markStart = prettyName.getMarkStart();
        int markEnd = prettyName.getMarkEnd();
        int oldMarkStart = markStart;
        int oldMarkEnd = markEnd;
        int length = text.length();
        boolean wasSpace = false;
        int firstNonSpace = 0;
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!wasSpace) {
                    wasSpace = true;
                    buf.append(text, firstNonSpace, i);
                    buf.append(' ');
                    continue;
                }
                if (oldMarkStart >= i) {
                    --markStart;
                }
                if (oldMarkEnd <= i) continue;
                --markEnd;
                continue;
            }
            if (wasSpace) {
                firstNonSpace = i;
            }
            wasSpace = false;
        }
        if (!wasSpace) {
            buf.append(text.substring(firstNonSpace));
        }
        return new PrettyName(buf.toString(), markStart, markEnd);
    }

    public PrettyName formatDefault(PrettyName prettyName) {
        return this.formatByCharsLength(prettyName, 25);
    }

    public PrettyName formatByCharsLength(PrettyName prettyName, int maxCharsLength) {
        boolean needCut;
        String text = prettyName.getText();
        int markStart = prettyName.getMarkStart();
        int markEnd = prettyName.getMarkEnd();
        boolean bl = needCut = text.length() > maxCharsLength;
        if (needCut) {
            if (markEnd < maxCharsLength && maxCharsLength - markEnd > 4) {
                text = text.substring(0, maxCharsLength) + CUT_SEQUENCE;
                needCut = false;
            } else {
                boolean bl2 = needCut = (text = text.substring(0, markEnd)).length() > maxCharsLength;
            }
        }
        if (needCut && markEnd - markStart < maxCharsLength) {
            text = CUT_SEQUENCE + text.substring(markEnd - maxCharsLength);
            markStart = maxCharsLength - markEnd + markStart + CUT_SEQUENCE.length();
            markEnd = maxCharsLength + CUT_SEQUENCE.length();
            needCut = false;
        }
        if (needCut && markStart > 0) {
            text = text.substring(markStart);
            markEnd -= markStart;
            markStart = 0;
            boolean bl3 = needCut = text.length() > maxCharsLength;
        }
        if (needCut) {
            text = text.substring(0, maxCharsLength) + CUT_SEQUENCE;
            markEnd = maxCharsLength;
        }
        if (markEnd > text.length()) {
            markEnd = text.length();
        }
        return new PrettyName(text, markStart, markEnd);
    }
}

