/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FastHashSet {
    private static final double TRESHOLD_KOEFF = 0.75;
    private static final int START_SIZE = 100;
    private static final int MAX_SIZE = 1000000;
    private Entry[] table;
    private int size = 100;
    private int numOfElems = 0;
    private int treshold = (int)((double)this.size * 0.75);

    public FastHashSet() {
        this.table = new Entry[this.size];
    }

    public void add(Entry vertex) {
        int hashCode = (vertex.hashCode2() & Integer.MAX_VALUE) % this.size;
        vertex.link = this.table[hashCode];
        this.table[hashCode] = vertex;
        if (++this.numOfElems >= this.treshold) {
            this.rehash();
        }
    }

    public Entry search(Entry vertex) {
        int hashCode = (vertex.hashCode2() & Integer.MAX_VALUE) % this.size;
        Entry e = this.table[hashCode];
        while (e != null) {
            if (vertex.equals(e)) {
                return e;
            }
            e = e.link;
        }
        return null;
    }

    public void delete(Entry vertex) {
        int hashCode = (vertex.hashCode2() & Integer.MAX_VALUE) % this.size;
        --this.numOfElems;
        if (this.table[hashCode] == vertex) {
            this.table[hashCode] = this.table[hashCode].link;
            return;
        }
        Entry e = this.table[hashCode];
        while (e != null) {
            if (e.link == vertex) {
                e.link = vertex.link;
                return;
            }
            e = e.link;
        }
        throw new IllegalArgumentException(Messages.getString(FastHashSet.class.getName() + "-0"));
    }

    private void rehash() {
        this.size *= 2;
        Entry[] newTable = new Entry[this.size];
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry aTable;
            Entry cur = aTable = entryArray[i];
            while (cur != null) {
                Entry next = cur.link;
                int newIndex = (cur.hashCode2() & Integer.MAX_VALUE) % this.size;
                cur.link = newTable[newIndex];
                newTable[newIndex] = cur;
                cur = next;
            }
        }
        this.table = newTable;
        this.treshold = this.size * 2 > 1000000 ? Integer.MAX_VALUE : (int)((double)(this.size * 2) * 0.75);
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeInt(this.numOfElems);
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry aTable;
            Entry cur = aTable = entryArray[i];
            while (cur != null) {
                out.writeObject(cur);
                cur = cur.link;
            }
        }
    }

    public static FastHashSet deserialize(ObjectInputStream in) throws IOException, ClassNotFoundException {
        FastHashSet fastHashSet = new FastHashSet();
        int numOfElems = in.readInt();
        for (int i = 0; i < numOfElems; ++i) {
            Entry vertex = (Entry)in.readObject();
            fastHashSet.add(vertex);
        }
        return fastHashSet;
    }

    public static abstract class Entry {
        Entry link;

        public abstract int hashCode2();
    }
}

