/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLHelper {
    private static UICallback uiCallback;

    public XMLHelper(UICallback callback) {
        uiCallback = callback;
    }

    public static Document readDocument(InputStream stream, final String sourcePath, boolean isValidating, final boolean isErrorsFatal) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(isValidating);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                    uiCallback.showWarning(Messages.getString(XMLHelper.class.getName() + "-0") + sourcePath + Messages.getString(XMLHelper.class.getName() + "-1") + exception.getLineNumber() + ":" + exception.getColumnNumber(), exception);
                }

                @Override
                public void error(SAXParseException exception) {
                    uiCallback.showError(Messages.getString(XMLHelper.class.getName() + "-2") + sourcePath + Messages.getString(XMLHelper.class.getName() + "-3") + exception.getLineNumber() + ":" + exception.getColumnNumber(), exception, isErrorsFatal);
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    uiCallback.showError(Messages.getString(XMLHelper.class.getName() + "-4") + sourcePath + Messages.getString(XMLHelper.class.getName() + "-5") + exception.getLineNumber() + ":" + exception.getColumnNumber(), exception, isErrorsFatal);
                }
            });
            return XMLHelper.substituteActualMessages(builder.parse(stream));
        }
        catch (Throwable e) {
            uiCallback.showError(Messages.getString(XMLHelper.class.getName() + "-6") + sourcePath + "\"", e, isErrorsFatal);
            return null;
        }
    }

    public static void writeDocument(OutputStream stream, Document document2, String sourcePath, boolean isErrorsFatal) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document2), new StreamResult(writer));
            writer.flush();
            writer.close();
        }
        catch (Throwable e) {
            uiCallback.showError(Messages.getString(XMLHelper.class.getName() + "-7") + sourcePath + "\"", e, isErrorsFatal);
        }
    }

    public static Document substituteActualMessages(Document document2) {
        new XMLVisitor().visitElement(document2.getDocumentElement());
        return document2;
    }

    private static class XMLVisitor {
        private XMLVisitor() {
        }

        private void visitElement(Element element) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.item(i).getNodeValue().startsWith("%")) continue;
                String messageKey = attributes.item(i).getNodeValue().substring(1).trim();
                attributes.item(i).setNodeValue(Messages.getString(messageKey));
            }
            NodeList kids = element.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node node = kids.item(i);
                if (node instanceof Element) {
                    this.visitElement((Element)node);
                    continue;
                }
                if (!(node instanceof Text) || !node.getNodeValue().startsWith("%")) continue;
                String messageKey = node.getNodeValue().substring(1).trim();
                node.setNodeValue(Messages.getString(messageKey));
            }
        }
    }
}

