/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.visitors;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.dump.RelationDump;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.Formatter;
import com.jetbrains.sourceglider.visitors.Visitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class VisitorsManager {
    private Map<String, Visitor> nameToVisitorMap = new HashMap<String, Visitor>();

    public Visitor[] getAvailableVisitors() {
        return (Visitor[])ArrayHelper.castArray(this.nameToVisitorMap.values().toArray(), Visitor.class);
    }

    public void addVisitor(Visitor visitor) {
        this.nameToVisitorMap.put(visitor.getName(), visitor);
    }

    public Visitor getVisitor(String name2) {
        return this.nameToVisitorMap.get(name2);
    }

    public void init() {
    }

    public Task[] getInitTasks(boolean isIncrementalBuild, Map options, boolean processUnitsSeparately) {
        return new Task[0];
    }

    public IRelation[] getSerializeableRelations() {
        return new IRelation[0];
    }

    public void serialize(ObjectOutputStream out) throws IOException {
    }

    public void deserialize(ObjectInputStream in, IRelation[] relationsBuffer, int pos) throws IOException, ClassNotFoundException {
    }

    public void run(Visitor[] visitors, Map options, ManagerInstancesProvider provider2, ThreadCallback threadCallback) {
        RelationDump dump = new RelationDump(provider2);
        for (Visitor visitor : visitors) {
            visitor.initRelations(dump);
            visitor.run(options, threadCallback);
        }
        dump.copyToRepository(provider2.getRelationsRepository());
        provider2.getBDDManager().collectGarbage();
    }

    public int getMemoryState() {
        return 0;
    }

    public void printInfo(Console console) {
        console.println(Messages.getString(VisitorsManager.class.getName() + "-0") + Formatter.formatSize(this.getMemoryState()));
    }
}

