/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.visitors.filters;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.XMLHelper;
import com.jetbrains.sourceglider.visitors.filters.ArrayFilters;
import com.jetbrains.sourceglider.visitors.filters.ThreadFilters;
import java.io.InputStream;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FiltersReader {
    public static final String FILTERS_PATH = "filters.xml";
    public static final String DEFAULT_FILTERS_PATH = "default-filters.xml";
    public static final String NO_PARAM_STRING = Messages.getString(FiltersReader.class.getName() + "-122");
    public static final String CONCRETE_TYPE_STRING = Messages.getString(FiltersReader.class.getName() + "-123");
    public static final String INVOCATOR_STRING = Messages.getString(FiltersReader.class.getName() + "-5");
    public static final String RESULT_STRING = Messages.getString(FiltersReader.class.getName() + "-6");
    public static final String KEYS_STRING = Messages.getString(FiltersReader.class.getName() + "-7");
    public static final String VALUES_STRING = Messages.getString(FiltersReader.class.getName() + "-8");
    public static final String BOTH_STRING = Messages.getString(FiltersReader.class.getName() + "-9");
    private ManagerInstancesProvider managerInstancesProvider;
    private final UICallback uiCallback;

    public FiltersReader(ManagerInstancesProvider managerInstancesProvider) {
        this.managerInstancesProvider = managerInstancesProvider;
        this.uiCallback = managerInstancesProvider.getUICallback();
    }

    public void readFilters(ArrayFilters arrayFilters, ThreadFilters threadFilters) {
        Document document2 = null;
        try {
            URL url = this.managerInstancesProvider.getURL(FILTERS_PATH);
            if (url == null) {
                this.uiCallback.showError(Messages.getString(FiltersReader.class.getName() + "-4") + FILTERS_PATH + "\"", false);
                return;
            }
            InputStream stream = url.openStream();
            document2 = XMLHelper.readDocument(stream, FILTERS_PATH, false, false);
            stream.close();
        }
        catch (Throwable e) {
            this.uiCallback.showError(Messages.getString(FiltersReader.class.getName() + "-3") + FILTERS_PATH + "\"", e, false);
            return;
        }
        if (document2 == null || document2.getDocumentElement() == null) {
            return;
        }
        NodeList groups = document2.getDocumentElement().getChildNodes();
        for (int i = 0; i < groups.getLength(); ++i) {
            NodeList elements = groups.item(i).getChildNodes();
            for (int j = 0; j < elements.getLength(); ++j) {
                Element element;
                if (!(elements.item(j) instanceof Element) || !(element = (Element)elements.item(j)).getAttribute("enabled").equals("true")) continue;
                if (element.getTagName().equals("container-types")) {
                    arrayFilters.addType(new ArrayFilters.ContainerType(element.getAttribute("signature"), this.readParamIndex(element.getAttribute("keys-type-param-index")), this.readParamIndex(element.getAttribute("elements-type-param-index")), element.getAttribute("concrete-type")));
                    continue;
                }
                if (element.getTagName().equals("array-access-method")) {
                    arrayFilters.addMethod(new ArrayFilters.ArrayAccessMetod(element.getAttribute("signature"), this.readNumber(element.getAttribute("num-of-params"))));
                    continue;
                }
                if (element.getTagName().equals("array-store-method")) {
                    arrayFilters.addMethod(new ArrayFilters.ArrayStoreMetod(element.getAttribute("signature"), this.readNumber(element.getAttribute("num-of-params")), this.readParamIndex(element.getAttribute("data-param-index")), this.readDomain(element.getAttribute("domain"))));
                    continue;
                }
                if (element.getTagName().equals("array-copy-method")) {
                    arrayFilters.addMethod(new ArrayFilters.ArrayCopyMetod(element.getAttribute("signature"), this.readNumber(element.getAttribute("num-of-params")), this.readParamIndex(element.getAttribute("src-param-index")), this.readParamIndex(element.getAttribute("dst-param-index")), this.readDomain(element.getAttribute("domain"))));
                    continue;
                }
                if (element.getTagName().equals("method-thread-prefix")) {
                    threadFilters.addMethodThread(new ThreadFilters.MethodThread(element.getAttribute("prefix"), element.getAttribute("thread")));
                    continue;
                }
                if (element.getTagName().equals("thread-switch")) {
                    threadFilters.addThreadSwitch(new ThreadFilters.ThreadSwitch(element.getAttribute("switch-signature"), element.getAttribute("thread"), element.getAttribute("thread-method-start-signature"), this.readParamIndex(element.getAttribute("thread-param-index"))));
                    continue;
                }
                if (!element.getTagName().equals("user-thread")) continue;
                threadFilters.addUserThread(new ThreadFilters.UserThread(element.getAttribute("type"), element.getAttribute("signature")));
            }
        }
    }

    private int readNumber(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            this.uiCallback.showError(Messages.getString(FiltersReader.class.getName() + "-0") + FILTERS_PATH + ": \"" + string + "\"", true);
            return -1;
        }
    }

    private int readParamIndex(String string) {
        if (string.equals(INVOCATOR_STRING)) {
            return -1;
        }
        if (string.equals(RESULT_STRING)) {
            return -2;
        }
        if (string.equals(NO_PARAM_STRING)) {
            return -1;
        }
        if (string.equals(CONCRETE_TYPE_STRING)) {
            return -2;
        }
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException e) {
            this.uiCallback.showError(Messages.getString(FiltersReader.class.getName() + "-1") + FILTERS_PATH + ": \"" + string + "\"", true);
            return -1;
        }
    }

    private int readDomain(String string) {
        if (string.equals(KEYS_STRING)) {
            return 1;
        }
        if (string.equals(VALUES_STRING)) {
            return 0;
        }
        if (string.equals(BOTH_STRING)) {
            return 2;
        }
        this.uiCallback.showError(Messages.getString(FiltersReader.class.getName() + "-2") + FILTERS_PATH + ": \"" + string + "\"", true);
        return -1;
    }
}

