/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        return JavaCodeFragmentFactory.getInstance((Project)project2).createExpressionCodeFragment(text, context, null, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        return ContainerUtil.map(DebuggerUtilsEx.getCodeFragmentFactories(context), factory -> factory.getFileType().getLanguage());
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project2, @Nullable XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            return this.getSupportedLanguages(this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project2));
        }
        return Collections.emptyList();
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project2, @NotNull Document document2, @Nullable Language language, @NotNull EvaluationMode mode) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (psiFile instanceof JavaCodeFragment) {
            return new XExpressionImpl(document2.getText(), language, StringUtil.nullize((String)((JavaCodeFragment)psiFile).importsToString()), mode);
        }
        return super.createExpression(project2, document2, language, mode);
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        TextWithImports text = TextWithImportsImpl.fromXExpression(expression);
        if (text != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context);
            JavaCodeFragment codeFragment = factory.createPresentationCodeFragment(text, context, project2);
            if (context != null) {
                PsiClass contextClass;
                PsiType contextType = (PsiType)context.getUserData(DebuggerUtilsImpl.PSI_TYPE_KEY);
                if (contextType == null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class})) != null) {
                    contextType = JavaPsiFacade.getElementFactory((Project)codeFragment.getProject()).createType(contextClass);
                }
                codeFragment.setThisType(contextType);
            }
            return codeFragment;
        }
        return super.createExpressionCodeFragment(project2, expression, context, isPhysical);
    }
}

