/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.highlighting.ManifestColorsAndFonts;
import org.jetbrains.lang.manifest.parser.ManifestLexer;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    public static final SyntaxHighlighter HIGHLIGHTER = new SyntaxHighlighterBase(){
        private final Map<IElementType, TextAttributesKey> myAttributes = new HashMap<IElementType, TextAttributesKey>();
        {
            this.myAttributes.put(ManifestTokenType.HEADER_NAME, ManifestColorsAndFonts.HEADER_NAME_KEY);
            this.myAttributes.put(ManifestTokenType.COLON, ManifestColorsAndFonts.HEADER_ASSIGNMENT_KEY);
            this.myAttributes.put(ManifestTokenType.HEADER_VALUE_PART, ManifestColorsAndFonts.HEADER_VALUE_KEY);
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            return new ManifestLexer();
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            return 1.pack((TextAttributesKey)this.myAttributes.get(tokenType));
        }
    };

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project2, @Nullable VirtualFile virtualFile) {
        return HIGHLIGHTER;
    }
}

