/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.parser.ManifestLexer;
import org.jetbrains.lang.manifest.parser.ManifestParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestElementType;
import org.jetbrains.lang.manifest.psi.impl.ManifestFileImpl;

public class ManifestParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project2) {
        return new ManifestLexer();
    }

    public PsiParser createParser(Project project2) {
        return new ManifestParser();
    }

    public IFileElementType getFileNodeType() {
        return ManifestElementType.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof ManifestElementType) {
            return ((ManifestElementType)type).createPsi(node);
        }
        return PsiUtilCore.NULL_PSI_ELEMENT;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new ManifestFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return left.getPsi() instanceof Header || right.getPsi() instanceof Header ? ParserDefinition.SpaceRequirements.MUST_LINE_BREAK : ParserDefinition.SpaceRequirements.MUST_NOT;
    }
}

