/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/jps/build/JpsFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "jpsProject", "Lorg/jetbrains/jps/model/JpsProject;", "(Lorg/jetbrains/jps/model/JpsProject;)V", "baseDirPath", "", "toFile", "Ljava/io/File;", "path", "toPath", "file", "jps-plugin"})
public final class JpsFileToPathConverter
implements FileToPathConverter {
    private final String baseDirPath;

    @Override
    @NotNull
    public String toPath(@NotNull File file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File file2 = file.getCanonicalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.canonicalFile");
        String path = FilesKt.getInvariantSeparatorsPath((File)file2);
        if (this.baseDirPath != null && StringsKt.startsWith$default((String)path, (String)this.baseDirPath, (boolean)false, (int)2, null)) {
            String string2 = path;
            int n = this.baseDirPath.length();
            StringBuilder stringBuilder = new StringBuilder().append("$PROJECT_DIR$");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            string = stringBuilder.append(string5).toString();
        } else {
            string = path;
        }
        return string;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"$PROJECT_DIR$", (boolean)false, (int)2, null)) {
            String string = this.baseDirPath;
            if (string == null) {
                String string2 = "Could not get project root dir";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String basePath = string;
            String string3 = path;
            int n = "$PROJECT_DIR$".length();
            StringBuilder stringBuilder = new StringBuilder().append(basePath);
            boolean bl = false;
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            String string6 = stringBuilder.append(string5).toString();
            file = new File(string6);
        } else {
            file = new File(path);
        }
        return file;
    }

    public JpsFileToPathConverter(@NotNull JpsProject jpsProject) {
        Intrinsics.checkParameterIsNotNull((Object)jpsProject, (String)"jpsProject");
        File file = JpsModelSerializationDataService.getBaseDirectory((JpsProject)jpsProject);
        this.baseDirPath = file != null && (file = file.getCanonicalFile()) != null ? FilesKt.getInvariantSeparatorsPath((File)file) : null;
    }
}

