/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u0016\u0010A\u001a\u0002092\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00000\tJ \u0010C\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020<0D2\b\b\u0002\u0010E\u001a\u00020\u0018J\u0006\u0010F\u001a\u000209J\u0006\u0010G\u001a\u00020\u0018J\b\u0010H\u001a\u00020/H\u0016R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R0\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u0011\u0010(\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001aR\u0011\u0010*\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001aR\u0011\u0010+\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\u0015\u00104\u001a\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\"\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "", "context", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "targets", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Ljava/util/List;)V", "_dependent", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "get_dependent$jps_plugin", "()Ljava/util/Set;", "set_dependent$jps_plugin", "(Ljava/util/Set;)V", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "compilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getCompilerArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "containsTests", "", "getContainsTests", "()Z", "getContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "<set-?>", "dependencies", "getDependencies", "()Ljava/util/List;", "setDependencies$jps_plugin", "(Ljava/util/List;)V", "dependent", "getDependent", "setDependent$jps_plugin", "haveSameCompiler", "getHaveSameCompiler", "isEnabled", "langVersion", "getLangVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "presentableModulesToCompilersList", "", "getPresentableModulesToCompilersList", "()Ljava/lang/String;", "presentableShortName", "getPresentableShortName", "representativeTarget", "getRepresentativeTarget", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargets", "addDependentCaches", "", "targetsCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "buildMetaInfoFile", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "collectDependentChunksRecursivelyExportedOnly", "result", "loadCaches", "", "loadDependent", "saveVersions", "shouldRebuild", "toString", "jps-plugin"})
public final class KotlinChunk {
    private final boolean containsTests;
    @NotNull
    public List<KotlinModuleBuildTarget.Dependency> dependencies;
    @NotNull
    public List<KotlinModuleBuildTarget.Dependency> dependent;
    @Nullable
    private Set<KotlinModuleBuildTarget.Dependency> _dependent;
    private final boolean haveSameCompiler;
    private final LanguageVersion defaultLanguageVersion;
    @NotNull
    private final CommonCompilerArguments compilerArguments;
    @NotNull
    private final LanguageVersion langVersion;
    @NotNull
    private final ApiVersion apiVersion;
    private final boolean isEnabled;
    @NotNull
    private final KotlinCompileContext context;
    @NotNull
    private final List<KotlinModuleBuildTarget<?>> targets;

    public final boolean getContainsTests() {
        return this.containsTests;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependencies() {
        List<KotlinModuleBuildTarget.Dependency> list = this.dependencies;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return list;
    }

    public final void setDependencies$jps_plugin(@NotNull List<KotlinModuleBuildTarget.Dependency> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.dependencies = list;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependent() {
        List<KotlinModuleBuildTarget.Dependency> list = this.dependent;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependent");
        }
        return list;
    }

    public final void setDependent$jps_plugin(@NotNull List<KotlinModuleBuildTarget.Dependency> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.dependent = list;
    }

    @Nullable
    public final Set<KotlinModuleBuildTarget.Dependency> get_dependent$jps_plugin() {
        return this._dependent;
    }

    public final void set_dependent$jps_plugin(@Nullable Set<KotlinModuleBuildTarget.Dependency> set) {
        this._dependent = set;
    }

    @NotNull
    public final KotlinModuleBuildTarget<?> getRepresentativeTarget() {
        return (KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets);
    }

    @NotNull
    public final String getPresentableModulesToCompilersList() {
        return kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)presentableModulesToCompilersList.1.INSTANCE, (int)31, null);
    }

    public final boolean getHaveSameCompiler() {
        return this.haveSameCompiler;
    }

    @NotNull
    public final CommonCompilerArguments getCompilerArguments() {
        return this.compilerArguments;
    }

    @NotNull
    public final LanguageVersion getLangVersion() {
        return this.langVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean shouldRebuild() {
        Object buildMetaInfo = this.getRepresentativeTarget().getBuildMetaInfoFactory().create(this.compilerArguments);
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            if (target.isVersionChanged(this, (BuildMetaInfo)buildMetaInfo)) {
                KotlinBuilder.Companion.getLOG().info(target + " version changed, rebuilding " + this);
                return true;
            }
            if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.INVALID) continue;
            TestingBuildLogger testingBuildLogger = this.context.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.invalidOrUnusedCache(this, null, target.getInitialLocalCacheAttributesDiff());
            }
            KotlinBuilder.Companion.getLOG().info(target + " cache is invalid " + target.getInitialLocalCacheAttributesDiff() + ", rebuilding " + this);
            return true;
        }
        return false;
    }

    @NotNull
    public final File buildMetaInfoFile(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new File(this.context.getDataPaths().getTargetDataRoot((BuildTarget)target), this.getRepresentativeTarget().getBuildMetaInfoFileName());
    }

    public final void saveVersions() {
        this.context.ensureLookupsCacheAttributesSaved();
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            CacheAttributesManager.DefaultImpls.writeVersion$default(it.getInitialLocalCacheAttributesDiff().getManager(), null, 1, null);
        }
        String serializedMetaInfo = this.getRepresentativeTarget().getBuildMetaInfoFactory().serializeToString(this.compilerArguments);
        Iterable $this$forEach$iv2 = this.targets;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            FilesKt.writeText$default((File)this.buildMetaInfoFile(it.getJpsModuleBuildTarget()), (String)serializedMetaInfo, null, (int)2, null);
        }
    }

    public final void collectDependentChunksRecursivelyExportedOnly(@NotNull Set<KotlinChunk> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        List<KotlinModuleBuildTarget.Dependency> list = this.dependent;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependent");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget.Dependency it = (KotlinModuleBuildTarget.Dependency)element$iv;
            boolean bl = false;
            if (!result.add(it.getSrc().getChunk()) || !it.getExported()) continue;
            it.getSrc().getChunk().collectDependentChunksRecursivelyExportedOnly(result);
        }
    }

    public static /* synthetic */ void collectDependentChunksRecursivelyExportedOnly$default(KotlinChunk kotlinChunk, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        kotlinChunk.collectDependentChunksRecursivelyExportedOnly(set);
    }

    @NotNull
    public final Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> loadCaches(boolean loadDependent) {
        BuildDataManager dataManager = this.context.getDataManager();
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> cacheByChunkTarget2 = CollectionsKt.keysToMapExceptNulls((Iterable)this.targets, (Function1)new Function1<KotlinModuleBuildTarget<?>, JpsIncrementalCache>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @Nullable
            public final JpsIncrementalCache invoke(@NotNull KotlinModuleBuildTarget<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                BuildDataManager buildDataManager = this.$dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                return JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        if (loadDependent) {
            this.addDependentCaches(cacheByChunkTarget2.values());
        }
        return cacheByChunkTarget2;
    }

    public static /* synthetic */ Map loadCaches$default(KotlinChunk kotlinChunk, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return kotlinChunk.loadCaches(bl);
    }

    private final void addDependentCaches(Collection<? extends JpsIncrementalCache> targetsCaches) {
        boolean bl = false;
        Set dependentChunks = new LinkedHashSet();
        this.collectDependentChunksRecursivelyExportedOnly(dependentChunks);
        BuildDataManager dataManager = this.context.getDataManager();
        Iterable $this$forEach$iv = dependentChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk decedentChunk = (KotlinChunk)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = decedentChunk.targets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl3 = false;
                BuildDataManager buildDataManager = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache dependentCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (dependentCache == null) continue;
                for (JpsIncrementalCache jpsIncrementalCache : targetsCaches) {
                    jpsIncrementalCache.addJpsDependentCache(dependentCache);
                }
            }
        }
    }

    @NotNull
    public final String getPresentableShortName() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        if (this.containsTests) {
            $this$buildString.append("tests of ");
        }
        $this$buildString.append(((KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets)).getModule().getName());
        if (this.targets.size() > 1) {
            String andXMore = "and " + (this.targets.size() - 1) + " more";
            String other = ", " + SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.targets), (int)1), null, null, null, (int)0, null, null, (int)63, null);
            $this$buildString.append(other.length() < andXMore.length() ? other : andXMore);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return "KotlinChunk<" + this.getRepresentativeTarget().getClass().getSimpleName() + '>' + '(' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + ')';
    }

    @NotNull
    public final KotlinCompileContext getContext() {
        return this.context;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinChunk(@NotNull KotlinCompileContext context, @NotNull List<? extends KotlinModuleBuildTarget<?>> targets) {
        Object object;
        block20: {
            block19: {
                Object object2;
                Object object3;
                Object it;
                boolean bl;
                boolean bl2;
                Object object4;
                KotlinChunk kotlinChunk;
                block18: {
                    block17: {
                        boolean bl3;
                        boolean bl4;
                        block16: {
                            void $this$all$iv;
                            Set set;
                            boolean bl5;
                            KotlinModuleBuildTarget it2;
                            boolean bl6;
                            block15: {
                                void $this$any$iv22;
                                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                                Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
                                this.context = context;
                                this.targets = targets;
                                Iterable iterable = this.targets;
                                kotlinChunk = this;
                                boolean $i$f$any = false;
                                if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                                    bl6 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv22) {
                                        it2 = (KotlinModuleBuildTarget)element$iv;
                                        boolean bl7 = false;
                                        if (!it2.isTests()) continue;
                                        bl6 = true;
                                        break block15;
                                    }
                                    bl6 = false;
                                }
                            }
                            kotlinChunk.containsTests = bl5 = bl6;
                            kotlinChunk = this;
                            boolean $this$any$iv22 = false;
                            kotlinChunk._dependent = set = (Set)new LinkedHashSet();
                            Iterable $this$any$iv22 = this.targets;
                            kotlinChunk = this;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    it2 = (KotlinModuleBuildTarget)element$iv;
                                    boolean bl8 = false;
                                    if (Intrinsics.areEqual(it2.getClass(), this.getRepresentativeTarget().getClass())) continue;
                                    bl4 = false;
                                    break block16;
                                }
                                bl4 = true;
                            }
                        }
                        kotlinChunk.haveSameCompiler = bl3 = bl4;
                        this.defaultLanguageVersion = VersionView.Companion.getRELEASED_VERSION();
                        JpsModule jpsModule = this.getRepresentativeTarget().getJpsModuleBuildTarget().getModule();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"representativeTarget.jpsModuleBuildTarget.module");
                        object4 = ModuleSettingsKt.getKotlinCompilerArguments(jpsModule);
                        kotlinChunk = this;
                        bl2 = false;
                        bl = false;
                        it = object4;
                        boolean bl9 = false;
                        ((CommonCompilerArguments)it).setReportOutputFiles(true);
                        ((CommonToolArguments)it).setVersion(true);
                        if (((CommonCompilerArguments)it).getLanguageVersion() == null) {
                            ((CommonCompilerArguments)it).setLanguageVersion(this.defaultLanguageVersion.getVersionString());
                        }
                        object3 = object4;
                        kotlinChunk.compilerArguments = object3;
                        KotlinChunk kotlinChunk2 = this;
                        object2 = this.compilerArguments.getLanguageVersion();
                        if (object2 == null) break block17;
                        object4 = object2;
                        kotlinChunk = kotlinChunk2;
                        bl2 = false;
                        bl = false;
                        it = object4;
                        boolean bl10 = false;
                        object3 = LanguageVersion.Companion.fromVersionString((String)it);
                        kotlinChunk2 = kotlinChunk;
                        object2 = object3;
                        if (object2 != null) break block18;
                    }
                    object2 = this.defaultLanguageVersion;
                }
                kotlinChunk2.langVersion = object2;
                KotlinChunk kotlinChunk3 = this;
                object = this.compilerArguments.getApiVersion();
                if (object == null) break block19;
                object4 = object;
                kotlinChunk = kotlinChunk3;
                bl2 = false;
                bl = false;
                it = object4;
                boolean bl11 = false;
                object3 = ApiVersion.Companion.parse((String)it);
                kotlinChunk3 = kotlinChunk;
                object = object3;
                if (object != null) break block20;
            }
            object = ApiVersion.Companion.createByLanguageVersion(this.langVersion);
        }
        kotlinChunk3.apiVersion = object;
        this.isEnabled = this.getRepresentativeTarget().isEnabled(this.compilerArguments);
    }
}

