/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.Bootstrap;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.util.Comparing;
import java.awt.AWTError;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class Main {
    public static final int NO_GRAPHICS = 1;
    public static final int RESTART_FAILED = 2;
    public static final int STARTUP_EXCEPTION = 3;
    public static final int JDK_CHECK_FAILED = 4;
    public static final int DIR_CHECK_FAILED = 5;
    public static final int INSTANCE_CHECK_FAILED = 6;
    public static final int LICENSE_ERROR = 7;
    public static final int PLUGIN_ERROR = 8;
    public static final int OUT_OF_MEMORY = 9;
    public static final int UNSUPPORTED_JAVA_VERSION = 10;
    public static final int PRIVACY_POLICY_REJECTION = 11;
    public static final int INSTALLATION_CORRUPTED = 12;
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    private static final String[] NO_ARGS = new String[0];
    private static final List<String> HEADLESS_COMMANDS = Arrays.asList("ant", "duplocate", "traverseUI", "buildAppcodeCache", "format", "keymap", "update", "inspections", "intentions");
    private static final List<String> GUI_COMMANDS = Arrays.asList("diff", "merge");
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean hasGraphics;

    private Main() {
    }

    public static void main(String[] args) {
        if (args.length == 1 && "%f".equals(args[0])) {
            args = NO_ARGS;
        }
        if (args.length == 1 && args[0].startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)args[0]);
            args = NO_ARGS;
        }
        Main.setFlags(args);
        if (!Main.isHeadless() && !Main.checkGraphics()) {
            System.exit(1);
        }
        if (Main.isStudio() && !Main.isHeadless()) {
            StudioCrashDetection.start();
        }
        try {
            Bootstrap.main(args, Main.class.getName() + "Impl", "start");
        }
        catch (Throwable t) {
            Main.showMessage("Start Failed", t);
            System.exit(3);
        }
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static void setFlags(String[] args) {
        isHeadless = Main.isHeadless(args);
        isCommandLine = Main.isCommandLine(args);
        if (Main.isHeadless()) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        }
    }

    public static boolean isHeadless(String[] args) {
        if (Boolean.valueOf(System.getProperty(AWT_HEADLESS)).booleanValue()) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String firstArg = args[0];
        return HEADLESS_COMMANDS.contains(firstArg) || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    private static boolean isCommandLine(String[] args) {
        return Main.isHeadless(args) || args.length > 0 && GUI_COMMANDS.contains(args[0]);
    }

    private static boolean checkGraphics() {
        if (GraphicsEnvironment.isHeadless()) {
            Main.showMessage("Startup Error", "Unable to detect graphics environment", true);
            return false;
        }
        return true;
    }

    public static boolean isApplicationStarterForBuilding(String[] args) {
        return args.length > 0 && (Comparing.strEqual((String)args[0], (String)"traverseUI") || Comparing.strEqual((String)args[0], (String)"listBundledPlugins") || Comparing.strEqual((String)args[0], (String)"buildAppcodeCache"));
    }

    private static boolean isStudio() {
        return "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
    }

    public static void showMessage(String title, Throwable t) {
        StringWriter message = new StringWriter();
        AWTError awtError = Main.findGraphicsError(t);
        if (awtError != null) {
            message.append("Failed to initialize graphics environment\n\n");
            hasGraphics = false;
            t = awtError;
        } else {
            message.append("Internal error. Please report to ");
            boolean studio = Main.isStudio();
            message.append(studio ? "https://code.google.com/p/android/issues" : "http://jb.gg/ide/critical-startup-errors");
            message.append("\n\n");
        }
        t.printStackTrace(new PrintWriter(message));
        Main.showMessage(title, message.toString(), true);
    }

    private static AWTError findGraphicsError(Throwable t) {
        while (t != null) {
            if (t instanceof AWTError) {
                return (AWTError)t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static void showMessage(String title, String message, boolean error) {
        boolean headless;
        PrintStream stream = error ? System.err : System.out;
        stream.println("\n" + title + ": " + message);
        boolean bl = headless = !hasGraphics || Main.isCommandLine() || GraphicsEnvironment.isHeadless();
        if (!headless) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                JTextPane textPane = new JTextPane();
                textPane.setEditable(false);
                textPane.setText(message.replaceAll("\t", "    "));
                textPane.setBackground(UIManager.getColor("Panel.background"));
                textPane.setCaretPosition(0);
                JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
                scrollPane.setBorder(null);
                int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
                int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
                Dimension component = scrollPane.getPreferredSize();
                if (component.height > maxHeight || component.width > maxWidth) {
                    scrollPane.setPreferredSize(new Dimension(Math.min(maxWidth, component.width), Math.min(maxHeight, component.height)));
                }
                int type = error ? 0 : 2;
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, title, type);
            }
            catch (Throwable t) {
                stream.println("\nAlso, an UI exception occurred on attempt to show above message:");
                t.printStackTrace(stream);
            }
        }
    }

    static {
        hasGraphics = true;
    }
}

