/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetails {
    public static final StudioCrashDetails UNKNOWN = new StudioCrashDetails("<unknown>", false, -1L);
    private static final String JVM_CRASH_FILE_STRING_FORMAT = System.getProperty("user.home") + File.separator + "java_error_in_STUDIO_%d.log";
    private final String myDescription;
    private final boolean myJvmCrash;
    private final long myUptimeInMs;

    private StudioCrashDetails(String description, boolean isJvmCrash, long uptimeInMs) {
        this.myDescription = description;
        this.myJvmCrash = isJvmCrash;
        this.myUptimeInMs = uptimeInMs;
    }

    @NotNull
    public static StudioCrashDetails loadFromRecordFile(File record) throws IOException {
        BasicFileAttributes attrs;
        long crashDateInMs;
        Path jvmCrashReportFile;
        List lines = FileUtil.loadLines((File)record);
        String buildNumber = !lines.isEmpty() ? (String)lines.get(0) : "";
        String runtimeVersion = lines.size() > 1 ? (String)lines.get(1) : "";
        long startupDateInMs = -1L;
        if (lines.size() > 2) {
            try {
                startupDateInMs = Long.parseLong((String)lines.get(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long pid = -1L;
        if (lines.size() > 3) {
            try {
                pid = Long.parseLong((String)lines.get(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean isJvmCrash = false;
        long uptimeInMs = -1L;
        if (startupDateInMs != -1L && pid >= 0L && Files.exists(jvmCrashReportFile = Paths.get(String.format(JVM_CRASH_FILE_STRING_FORMAT, pid), new String[0]), new LinkOption[0]) && (crashDateInMs = (attrs = Files.readAttributes(jvmCrashReportFile, BasicFileAttributes.class, new LinkOption[0])).creationTime().toMillis()) > startupDateInMs) {
            isJvmCrash = true;
            uptimeInMs = crashDateInMs - startupDateInMs;
        }
        String description = buildNumber + "\n" + runtimeVersion;
        return new StudioCrashDetails(description, isJvmCrash, uptimeInMs);
    }

    public boolean isJvmCrash() {
        return this.myJvmCrash;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public long getUptimeInMs() {
        return this.myUptimeInMs;
    }
}

