/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableDatabase;
import org.eclipse.jgit.internal.storage.dfs.ReftableStack;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class ReftableBatchRefUpdate
extends BatchRefUpdate {
    private static final int AVG_BYTES = 36;
    private final DfsReftableDatabase refdb;
    private final DfsObjDatabase odb;
    private final ReentrantLock lock;
    private final ReftableConfig reftableConfig;

    protected ReftableBatchRefUpdate(DfsReftableDatabase refdb, DfsObjDatabase odb) {
        super(refdb);
        this.refdb = refdb;
        this.odb = odb;
        this.lock = refdb.getLock();
        this.reftableConfig = refdb.getReftableConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RevWalk rw, ProgressMonitor pm, List<String> options) {
        List<ReceiveCommand> pending = this.getPending();
        if (pending.isEmpty()) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        try {
            if (!this.checkObjectExistence(rw, pending)) {
                return;
            }
            if (!this.checkNonFastForwards(rw, pending)) {
                return;
            }
            this.lock.lock();
            try {
                Reftable table = this.refdb.reader();
                if (!this.checkExpected(table, pending)) {
                    return;
                }
                if (!this.checkConflicting(pending)) {
                    return;
                }
                if (!this.blockUntilTimestamps(MAX_WAIT)) {
                    return;
                }
                this.applyUpdates(rw, pending);
                for (ReceiveCommand cmd : pending) {
                    cmd.setResult(ReceiveCommand.Result.OK);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            pending.get(0).setResult(ReceiveCommand.Result.LOCK_FAILURE, "io error");
            ReceiveCommand.abort(pending);
        }
    }

    private List<ReceiveCommand> getPending() {
        return ReceiveCommand.filter(this.getCommands(), ReceiveCommand.Result.NOT_ATTEMPTED);
    }

    private boolean checkObjectExistence(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        for (ReceiveCommand cmd : pending) {
            try {
                if (cmd.getNewId().equals(ObjectId.zeroId())) continue;
                rw.parseAny(cmd.getNewId());
            }
            catch (MissingObjectException e) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
                ReceiveCommand.abort(pending);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand cmd : pending) {
            cmd.updateType(rw);
            if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
            ReceiveCommand.abort(pending);
            return false;
        }
        return true;
    }

    private boolean checkConflicting(List<ReceiveCommand> pending) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (ReceiveCommand cmd : pending) {
            names.add(cmd.getRefName());
        }
        boolean ok = true;
        block1: for (ReceiveCommand cmd : pending) {
            String name = cmd.getRefName();
            if (this.refdb.isNameConflicting(name)) {
                cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                ok = false;
                continue;
            }
            int s = name.lastIndexOf(47);
            while (0 < s) {
                if (names.contains(name.substring(0, s))) {
                    cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                    ok = false;
                    continue block1;
                }
                s = name.lastIndexOf(47, s - 1);
            }
        }
        if (!ok && this.isAtomic()) {
            ReceiveCommand.abort(pending);
            return false;
        }
        return ok;
    }

    private boolean checkExpected(Reftable table, List<ReceiveCommand> pending) throws IOException {
        for (ReceiveCommand cmd : pending) {
            if (ReftableBatchRefUpdate.matchOld(cmd, table.exactRef(cmd.getRefName()))) continue;
            cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            if (!this.isAtomic()) continue;
            ReceiveCommand.abort(pending);
            return false;
        }
        return true;
    }

    private static boolean matchOld(ReceiveCommand cmd, @Nullable Ref ref) {
        if (ref == null) {
            return AnyObjectId.equals(ObjectId.zeroId(), cmd.getOldId()) && cmd.getOldSymref() == null;
        }
        if (ref.isSymbolic()) {
            return ref.getTarget().getName().equals(cmd.getOldSymref());
        }
        ObjectId id = ref.getObjectId();
        if (id == null) {
            id = ObjectId.zeroId();
        }
        return cmd.getOldId().equals(id);
    }

    private void applyUpdates(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        List<Ref> newRefs = ReftableBatchRefUpdate.toNewRefs(rw, pending);
        long updateIndex = this.nextUpdateIndex();
        Set<DfsPackDescription> prune = Collections.emptySet();
        DfsPackDescription pack = this.odb.newPack(DfsObjDatabase.PackSource.INSERT);
        try (DfsOutputStream out = this.odb.writeFile(pack, PackExt.REFTABLE);){
            ReftableWriter.Stats stats;
            ReftableConfig cfg = DfsPackCompactor.configureReftable(this.reftableConfig, out);
            if (this.refdb.compactDuringCommit() && newRefs.size() * 36 <= cfg.getRefBlockSize() && this.canCompactTopOfStack(cfg)) {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                this.write(tmp, cfg, updateIndex, newRefs, pending);
                stats = this.compactTopOfStack(out, cfg, tmp.toByteArray());
                prune = this.toPruneTopOfStack();
            } else {
                stats = this.write(out, cfg, updateIndex, newRefs, pending);
            }
            pack.addFileExt(PackExt.REFTABLE);
            pack.setReftableStats(stats);
        }
        this.odb.commitPack(Collections.singleton(pack), prune);
        this.odb.addReftable(pack, prune);
        this.refdb.clearCache();
    }

    private ReftableWriter.Stats write(OutputStream os, ReftableConfig cfg, long updateIndex, List<Ref> newRefs, List<ReceiveCommand> pending) throws IOException {
        ReftableWriter writer = new ReftableWriter(cfg).setMinUpdateIndex(updateIndex).setMaxUpdateIndex(updateIndex).begin(os).sortAndWriteRefs(newRefs);
        if (!this.isRefLogDisabled()) {
            this.writeLog(writer, updateIndex, pending);
        }
        writer.finish();
        return writer.getStats();
    }

    private void writeLog(ReftableWriter writer, long updateIndex, List<ReceiveCommand> pending) throws IOException {
        HashMap<String, ReceiveCommand> cmds = new HashMap<String, ReceiveCommand>();
        ArrayList<String> byName = new ArrayList<String>(pending.size());
        for (ReceiveCommand cmd : pending) {
            cmds.put(cmd.getRefName(), cmd);
            byName.add(cmd.getRefName());
        }
        Collections.sort(byName);
        PersonIdent ident = this.getRefLogIdent();
        if (ident == null) {
            ident = new PersonIdent(this.refdb.getRepository());
        }
        for (String name : byName) {
            String strResult;
            ReceiveCommand cmd = (ReceiveCommand)cmds.get(name);
            if (this.isRefLogDisabled(cmd)) continue;
            String msg = this.getRefLogMessage(cmd);
            if (this.isRefLogIncludingResult(cmd) && (strResult = this.toResultString(cmd)) != null) {
                msg = msg.isEmpty() ? strResult : msg + ": " + strResult;
            }
            writer.writeLog(name, updateIndex, ident, cmd.getOldId(), cmd.getNewId(), msg);
        }
    }

    private String toResultString(ReceiveCommand cmd) {
        switch (cmd.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static List<Ref> toNewRefs(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        ArrayList<Ref> refs = new ArrayList<Ref>(pending.size());
        for (ReceiveCommand cmd : pending) {
            String name = cmd.getRefName();
            ObjectId newId = cmd.getNewId();
            String newSymref = cmd.getNewSymref();
            if (AnyObjectId.equals(ObjectId.zeroId(), newId) && newSymref == null) {
                refs.add(new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null));
                continue;
            }
            if (newSymref != null) {
                refs.add(new SymbolicRef(name, new ObjectIdRef.Unpeeled(Ref.Storage.NEW, newSymref, null)));
                continue;
            }
            RevObject obj = rw.parseAny(newId);
            RevObject peel = null;
            if (obj instanceof RevTag) {
                peel = rw.peel(obj);
            }
            if (peel != null) {
                refs.add(new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, name, newId, peel.copy()));
                continue;
            }
            refs.add(new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, newId));
        }
        return refs;
    }

    private long nextUpdateIndex() throws IOException {
        long updateIndex = 0L;
        for (Reftable r : this.refdb.stack().readers()) {
            if (!(r instanceof ReftableReader)) continue;
            updateIndex = Math.max(updateIndex, ((ReftableReader)r).maxUpdateIndex());
        }
        return updateIndex + 1L;
    }

    private boolean canCompactTopOfStack(ReftableConfig cfg) throws IOException {
        ReftableStack stack = this.refdb.stack();
        List<Reftable> readers = stack.readers();
        if (readers.isEmpty()) {
            return false;
        }
        int lastIdx = readers.size() - 1;
        DfsReftable last = stack.files().get(lastIdx);
        DfsPackDescription desc = last.getPackDescription();
        if (desc.getPackSource() != DfsObjDatabase.PackSource.INSERT || !this.packOnlyContainsReftable(desc)) {
            return false;
        }
        Reftable table = readers.get(lastIdx);
        int bs = cfg.getRefBlockSize();
        return table instanceof ReftableReader && ((ReftableReader)table).size() <= (long)(3 * bs);
    }

    private ReftableWriter.Stats compactTopOfStack(OutputStream out, ReftableConfig cfg, byte[] newTable) throws IOException {
        List<Reftable> stack = this.refdb.stack().readers();
        Reftable last = stack.get(stack.size() - 1);
        ArrayList<Reftable> tables = new ArrayList<Reftable>(2);
        tables.add(last);
        tables.add(new ReftableReader(BlockSource.from(newTable)));
        ReftableCompactor compactor = new ReftableCompactor();
        compactor.setConfig(cfg);
        compactor.setIncludeDeletes(true);
        compactor.addAll(tables);
        compactor.compact(out);
        return compactor.getStats();
    }

    private Set<DfsPackDescription> toPruneTopOfStack() throws IOException {
        List<DfsReftable> stack = this.refdb.stack().files();
        DfsReftable last = stack.get(stack.size() - 1);
        return Collections.singleton(last.getPackDescription());
    }

    private boolean packOnlyContainsReftable(DfsPackDescription desc) {
        for (PackExt ext : PackExt.values()) {
            if (ext == PackExt.REFTABLE || !desc.hasFileExt(ext)) continue;
            return false;
        }
        return true;
    }
}

