/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.ConstantPoolCacheEntry;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ConstantTag;
import sun.jvm.hotspot.utilities.U1Array;
import sun.jvm.hotspot.utilities.U2Array;

public class ConstantPool
extends Metadata
implements ClassConstants {
    private static final boolean DEBUG = false;
    private static AddressField tags;
    private static AddressField operands;
    private static AddressField cache;
    private static MetadataField poolHolder;
    private static CIntField length;
    private static AddressField resolvedReferences;
    private static AddressField referenceMap;
    private static long headerSize;
    private static long elementSize;
    private static int INDY_BSM_OFFSET;
    private static int INDY_ARGC_OFFSET;
    private static int INDY_ARGV_OFFSET;
    private static final String[] nameForTag;

    protected void debugMessage(String message) {
        System.out.println(message);
    }

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ConstantPool");
        tags = type.getAddressField("_tags");
        operands = type.getAddressField("_operands");
        cache = type.getAddressField("_cache");
        poolHolder = new MetadataField(type.getAddressField("_pool_holder"), 0L);
        length = new CIntField(type.getCIntegerField("_length"), 0L);
        resolvedReferences = type.getAddressField("_resolved_references");
        referenceMap = type.getAddressField("_reference_map");
        headerSize = type.getSize();
        elementSize = 0L;
        INDY_BSM_OFFSET = db.lookupIntConstant("ConstantPool::_indy_bsm_offset");
        INDY_ARGC_OFFSET = db.lookupIntConstant("ConstantPool::_indy_argc_offset");
        INDY_ARGV_OFFSET = db.lookupIntConstant("ConstantPool::_indy_argv_offset");
    }

    public ConstantPool(Address addr) {
        super(addr);
    }

    public boolean isConstantPool() {
        return true;
    }

    public U1Array getTags() {
        return new U1Array(tags.getValue(this.getAddress()));
    }

    public U2Array getOperands() {
        return new U2Array(operands.getValue(this.getAddress()));
    }

    public ConstantPoolCache getCache() {
        Address addr = cache.getValue(this.getAddress());
        return (ConstantPoolCache)VMObjectFactory.newObject(ConstantPoolCache.class, addr);
    }

    public InstanceKlass getPoolHolder() {
        return (InstanceKlass)poolHolder.getValue(this);
    }

    public int getLength() {
        return (int)length.getValue(this.getAddress());
    }

    public Oop getResolvedReferences() {
        Address handle = resolvedReferences.getValue(this.getAddress());
        if (handle != null) {
            OopHandle refs = handle.getOopHandleAt(0L);
            return VM.getVM().getObjectHeap().newOop(refs);
        }
        return null;
    }

    public U2Array referenceMap() {
        return new U2Array(referenceMap.getValue(this.getAddress()));
    }

    public int objectToCPIndex(int index) {
        return this.referenceMap().at(index);
    }

    private long getElementSize() {
        if (elementSize != 0L) {
            return elementSize;
        }
        elementSize = VM.getVM().getOopSize();
        return elementSize;
    }

    private long indexOffset(long index) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index >= 0L && index < (long)this.getLength(), "invalid cp index " + index + " " + this.getLength());
        }
        return index * this.getElementSize() + headerSize;
    }

    public ConstantTag getTagAt(long index) {
        return new ConstantTag(this.getTags().at((int)index));
    }

    public CPSlot getSlotAt(long index) {
        return new CPSlot(this.getAddressAtRaw(index));
    }

    public Address getAddressAtRaw(long index) {
        return this.getAddress().getAddressAt(this.indexOffset(index));
    }

    public Symbol getSymbolAt(long index) {
        return Symbol.create(this.getAddressAtRaw(index));
    }

    public int getIntAt(long index) {
        return this.getAddress().getJIntAt(this.indexOffset(index));
    }

    public float getFloatAt(long index) {
        return this.getAddress().getJFloatAt(this.indexOffset(index));
    }

    public long getLongAt(long index) {
        int oneHalf = this.getAddress().getJIntAt(this.indexOffset(index + 1L));
        int otherHalf = this.getAddress().getJIntAt(this.indexOffset(index));
        return VM.getVM().buildLongFromIntsPD(oneHalf, otherHalf);
    }

    public double getDoubleAt(long index) {
        return Double.longBitsToDouble(this.getLongAt(index));
    }

    public int getFieldOrMethodAt(int which) {
        int i = -1;
        ConstantPoolCache cache = this.getCache();
        i = cache == null ? which : cache.getEntryAt(0xFFFF & which).getConstantPoolIndex();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isFieldOrMethod(), "Corrupted constant pool");
        }
        int res = this.getIntAt(i);
        return res;
    }

    public int[] getNameAndTypeAt(int which) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(which).isNameAndType(), "Corrupted constant pool: " + which + " " + this.getTagAt(which));
        }
        int i = this.getIntAt(which);
        return new int[]{ConstantPool.extractLowShortFromInt(i), ConstantPool.extractHighShortFromInt(i)};
    }

    public Symbol getNameRefAt(int which) {
        return this.implGetNameRefAt(which, false);
    }

    public Symbol uncachedGetNameRefAt(int which) {
        return this.implGetNameRefAt(which, true);
    }

    private Symbol implGetNameRefAt(int which, boolean uncached) {
        int signatureIndex = this.getNameRefIndexAt(this.implNameAndTypeRefIndexAt(which, uncached));
        return this.getSymbolAt(signatureIndex);
    }

    public Symbol getSignatureRefAt(int which) {
        return this.implGetSignatureRefAt(which, false);
    }

    public Symbol uncachedGetSignatureRefAt(int which) {
        return this.implGetSignatureRefAt(which, true);
    }

    private Symbol implGetSignatureRefAt(int which, boolean uncached) {
        int signatureIndex = this.getSignatureRefIndexAt(this.implNameAndTypeRefIndexAt(which, uncached));
        return this.getSymbolAt(signatureIndex);
    }

    public static boolean isInvokedynamicIndex(int i) {
        return i < 0;
    }

    public static int decodeInvokedynamicIndex(int i) {
        Assert.that(ConstantPool.isInvokedynamicIndex(i), "");
        return ~i;
    }

    public int invokedynamicCPCacheIndex(int index) {
        Assert.that(ConstantPool.isInvokedynamicIndex(index), "should be a invokedynamic index");
        return ConstantPool.decodeInvokedynamicIndex(index);
    }

    ConstantPoolCacheEntry invokedynamicCPCacheEntryAt(int index) {
        int cpCacheIndex = this.invokedynamicCPCacheIndex(index);
        return this.getCache().getEntryAt(cpCacheIndex);
    }

    private int implNameAndTypeRefIndexAt(int which, boolean uncached) {
        int i = which;
        if (!uncached && this.getCache() != null) {
            if (ConstantPool.isInvokedynamicIndex(which)) {
                int poolIndex = this.invokedynamicCPCacheEntryAt(which).getConstantPoolIndex();
                poolIndex = this.invokeDynamicNameAndTypeRefIndexAt(poolIndex);
                Assert.that(this.getTagAt(poolIndex).isNameAndType(), "");
                return poolIndex;
            }
            i = this.remapInstructionOperandFromCache(which);
        } else if (this.getTagAt(which).isInvokeDynamic()) {
            int poolIndex = this.invokeDynamicNameAndTypeRefIndexAt(which);
            Assert.that(this.getTagAt(poolIndex).isNameAndType(), "");
            return poolIndex;
        }
        int refIndex = this.getIntAt(i);
        return ConstantPool.extractHighShortFromInt(refIndex);
    }

    private int remapInstructionOperandFromCache(int operand) {
        int cpc_index = operand;
        int member_index = this.getCache().getEntryAt(cpc_index).getConstantPoolIndex();
        return member_index;
    }

    int invokeDynamicNameAndTypeRefIndexAt(int which) {
        return ConstantPool.extractHighShortFromInt(this.getIntAt(which));
    }

    public Klass getKlassAt(int which) {
        if (!this.getTagAt(which).isKlass()) {
            return null;
        }
        return (Klass)Metadata.instantiateWrapperFor(this.getAddressAtRaw(which));
    }

    public Symbol getKlassNameAt(int which) {
        CPSlot entry = this.getSlotAt(which);
        if (entry.isResolved()) {
            return entry.getKlass().getName();
        }
        return entry.getSymbol();
    }

    public Symbol getUnresolvedStringAt(int which) {
        return this.getSymbolAt(which);
    }

    public InstanceKlass getFieldOrMethodKlassRefAt(int which) {
        int refIndex = this.getFieldOrMethodAt(which);
        int klassIndex = ConstantPool.extractLowShortFromInt(refIndex);
        return (InstanceKlass)this.getKlassAt(klassIndex);
    }

    public Method getMethodRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findMethod(name, sig);
    }

    public Field getFieldRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findField(name, sig);
    }

    public int getNameAndTypeRefIndexAt(int index) {
        return this.implNameAndTypeRefIndexAt(index, false);
    }

    public int getNameRefIndexAt(int index) {
        int[] refIndex = this.getNameAndTypeAt(index);
        int i = refIndex[0];
        return i;
    }

    public int getSignatureRefIndexAt(int index) {
        int[] refIndex = this.getNameAndTypeAt(index);
        int i = refIndex[1];
        return i;
    }

    public int getMethodHandleIndexAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodHandle(), "Corrupted constant pool");
        }
        int res = ConstantPool.extractHighShortFromInt(this.getIntAt(i));
        return res;
    }

    public int getMethodHandleRefKindAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodHandle(), "Corrupted constant pool");
        }
        int res = ConstantPool.extractLowShortFromInt(this.getIntAt(i));
        return res;
    }

    public int getMethodTypeIndexAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodType(), "Corrupted constant pool");
        }
        int res = this.getIntAt(i);
        return res;
    }

    public short[] getBootstrapSpecifierAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isInvokeDynamic(), "Corrupted constant pool");
        }
        int bsmSpec = ConstantPool.extractLowShortFromInt(this.getIntAt(i));
        U2Array operands = this.getOperands();
        if (operands == null) {
            return null;
        }
        int basePos = VM.getVM().buildIntFromShorts(operands.at(bsmSpec * 2 + 0), operands.at(bsmSpec * 2 + 1));
        int argv = basePos + INDY_ARGV_OFFSET;
        short argc = operands.at(basePos + INDY_ARGC_OFFSET);
        int endPos = argv + argc;
        short[] values = new short[endPos - basePos];
        for (int j = 0; j < values.length; ++j) {
            values[j] = operands.at(basePos + j);
        }
        return values;
    }

    private String nameForTag(int tag) {
        switch (tag) {
            case 1: {
                return "JVM_CONSTANT_Utf8";
            }
            case 2: {
                return "JVM_CONSTANT_Unicode";
            }
            case 3: {
                return "JVM_CONSTANT_Integer";
            }
            case 4: {
                return "JVM_CONSTANT_Float";
            }
            case 5: {
                return "JVM_CONSTANT_Long";
            }
            case 6: {
                return "JVM_CONSTANT_Double";
            }
            case 7: {
                return "JVM_CONSTANT_Class";
            }
            case 8: {
                return "JVM_CONSTANT_String";
            }
            case 9: {
                return "JVM_CONSTANT_Fieldref";
            }
            case 10: {
                return "JVM_CONSTANT_Methodref";
            }
            case 11: {
                return "JVM_CONSTANT_InterfaceMethodref";
            }
            case 12: {
                return "JVM_CONSTANT_NameAndType";
            }
            case 15: {
                return "JVM_CONSTANT_MethodHandle";
            }
            case 16: {
                return "JVM_CONSTANT_MethodType";
            }
            case 18: {
                return "JVM_CONSTANT_InvokeDynamic";
            }
            case 0: {
                return "JVM_CONSTANT_Invalid";
            }
            case 100: {
                return "JVM_CONSTANT_UnresolvedClass";
            }
            case 101: {
                return "JVM_CONSTANT_ClassIndex";
            }
            case 102: {
                return "JVM_CONSTANT_StringIndex";
            }
            case 103: {
                return "JVM_CONSTANT_UnresolvedClassInError";
            }
            case 104: {
                return "JVM_CONSTANT_MethodHandleInError";
            }
            case 105: {
                return "JVM_CONSTANT_MethodTypeInError";
            }
        }
        throw new InternalError("Unknown tag: " + tag);
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        super.iterateFields(visitor);
        visitor.doMetadata(poolHolder, true);
        int length = this.getLength();
        block8: for (int index = 1; index < length; ++index) {
            byte ctag = this.getTags().at(index);
            switch (ctag) {
                case 3: 
                case 101: 
                case 102: {
                    visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    continue block8;
                }
                case 4: {
                    visitor.doFloat(new FloatField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    continue block8;
                }
                case 5: {
                    visitor.doLong(new LongField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    ++index;
                    continue block8;
                }
                case 6: {
                    visitor.doDouble(new DoubleField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    ++index;
                    continue block8;
                }
                case 1: 
                case 7: 
                case 100: 
                case 103: {
                    visitor.doOop(new OopField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    continue block8;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 18: {
                    visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                }
            }
        }
    }

    public void writeBytes(OutputStream os) throws IOException {
        byte cpConstType;
        HashMap<String, Short> utf8ToIndex = new HashMap<String, Short>();
        DataOutputStream dos = new DataOutputStream(os);
        U1Array tags = this.getTags();
        int len = this.getLength();
        int ci = 0;
        for (ci = 1; ci < len; ++ci) {
            cpConstType = tags.at(ci);
            if (cpConstType == 1) {
                Symbol sym = this.getSymbolAt(ci);
                utf8ToIndex.put(sym.asString(), new Short((short)ci));
                continue;
            }
            if (cpConstType != 5 && cpConstType != 6) continue;
            ++ci;
        }
        block17: for (ci = 1; ci < len; ++ci) {
            cpConstType = tags.at(ci);
            switch (cpConstType) {
                case 1: {
                    dos.writeByte(cpConstType);
                    Symbol sym = this.getSymbolAt(ci);
                    dos.writeShort((short)sym.getLength());
                    dos.write(sym.asByteArray());
                    continue block17;
                }
                case 2: {
                    throw new IllegalArgumentException("Unicode constant!");
                }
                case 3: {
                    dos.writeByte(cpConstType);
                    dos.writeInt(this.getIntAt(ci));
                    continue block17;
                }
                case 4: {
                    dos.writeByte(cpConstType);
                    dos.writeFloat(this.getFloatAt(ci));
                    continue block17;
                }
                case 5: {
                    dos.writeByte(cpConstType);
                    long l = this.getLongAt(ci);
                    ++ci;
                    dos.writeLong(l);
                    continue block17;
                }
                case 6: {
                    dos.writeByte(cpConstType);
                    dos.writeDouble(this.getDoubleAt(ci));
                    ++ci;
                    continue block17;
                }
                case 7: {
                    dos.writeByte(cpConstType);
                    Klass refKls = (Klass)Metadata.instantiateWrapperFor(this.getAddressAtRaw(ci));
                    String klassName = refKls.getName().asString();
                    Short s = (Short)utf8ToIndex.get(klassName);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 100: 
                case 103: {
                    dos.writeByte(7);
                    String klassName = this.getSymbolAt(ci).asString();
                    Short s = (Short)utf8ToIndex.get(klassName);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 8: {
                    dos.writeByte(cpConstType);
                    String str = this.getUnresolvedStringAt(ci).asString();
                    Short s = (Short)utf8ToIndex.get(str);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 9: 
                case 10: 
                case 11: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short klassIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(klassIndex);
                    dos.writeShort(nameAndTypeIndex);
                    continue block17;
                }
                case 12: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short nameIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short signatureIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(nameIndex);
                    dos.writeShort(signatureIndex);
                    continue block17;
                }
                case 15: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    byte refKind = (byte)ConstantPool.extractLowShortFromInt(value);
                    short memberIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeByte(refKind);
                    dos.writeShort(memberIndex);
                    continue block17;
                }
                case 16: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short refIndex = (short)value;
                    dos.writeShort(refIndex);
                    continue block17;
                }
                case 18: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short bsmIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(bsmIndex);
                    dos.writeShort(nameAndTypeIndex);
                    continue block17;
                }
                default: {
                    throw new InternalError("Unknown tag: " + cpConstType);
                }
            }
        }
        dos.flush();
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPool for " + this.getPoolHolder().getName().asString());
    }

    public long getSize() {
        return Oop.alignObjectSize(headerSize + (long)this.getLength());
    }

    private static int extractHighShortFromInt(int val) {
        return val >> 16 & 0xFFFF;
    }

    private static int extractLowShortFromInt(int val) {
        return val & 0xFFFF;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConstantPool.initialize(VM.getVM().getTypeDataBase());
            }
        });
        nameForTag = new String[0];
    }

    public class CPSlot {
        private Address ptr;

        CPSlot(Address ptr) {
            this.ptr = ptr;
        }

        CPSlot(Symbol sym) {
            this.ptr = sym.getAddress().orWithMask(1L);
        }

        public boolean isResolved() {
            return (this.ptr.minus(null) & 1L) == 0L;
        }

        public boolean isUnresolved() {
            return (this.ptr.minus(null) & 1L) == 1L;
        }

        public Symbol getSymbol() {
            if (!this.isUnresolved()) {
                throw new InternalError("not a symbol");
            }
            return Symbol.create(this.ptr.xorWithMask(1L));
        }

        public Klass getKlass() {
            if (!this.isResolved()) {
                throw new InternalError("not klass");
            }
            return (Klass)Metadata.instantiateWrapperFor(this.ptr);
        }
    }
}

