/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    private static final Language[] LANGUAGES = new Language[]{YAMLLanguage.INSTANCE};
    private static final int SCALAR_MAX_LENGTH = 20;

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof YAMLScalar || e instanceof YAMLKeyValue || e instanceof YAMLSequenceItem || e instanceof YAMLDocument;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e instanceof YAMLDocument) {
            YAMLFile file = (YAMLFile)e.getContainingFile();
            if (file == null) {
                return "Document";
            }
            List<YAMLDocument> documents = file.getDocuments();
            return "Document " + YAMLBreadcrumbsInfoProvider.getIndexOf(documents, e);
        }
        if (e instanceof YAMLKeyValue) {
            return ((YAMLKeyValue)e).getKeyText() + ':';
        }
        if (e instanceof YAMLSequenceItem) {
            PsiElement parent = e.getParent();
            if (!(parent instanceof YAMLSequence)) {
                return "Item";
            }
            List<YAMLSequenceItem> items = ((YAMLSequence)parent).getItems();
            return "Item " + YAMLBreadcrumbsInfoProvider.getIndexOf(items, e);
        }
        if (e instanceof YAMLScalar) {
            return StringUtil.first((String)((YAMLScalar)e).getTextValue(), (int)20, (boolean)true);
        }
        throw new IllegalArgumentException("This element should not pass #acceptElement");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        return null;
    }

    @NotNull
    public List<? extends Action> getContextActions(@NotNull PsiElement element) {
        if (!(element instanceof YAMLKeyValue) && !(element instanceof YAMLSequenceItem)) {
            return super.getContextActions(element);
        }
        final String configName = YAMLUtil.getConfigFullName((YAMLPsiElement)element);
        if (configName.isEmpty()) {
            return super.getContextActions(element);
        }
        return Collections.singletonList(new AbstractAction(YAMLBundle.message("YAMLBreadcrumbsInfoProvider.copy.key.to.clipboard")){

            @Override
            public void actionPerformed(ActionEvent event) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(configName));
            }
        });
    }

    @NotNull
    private static String getIndexOf(@NotNull List<?> list, Object o) {
        return String.valueOf(1 + list.indexOf(o)) + '/' + list.size();
    }
}

