/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.refactoring.rename.YamlKeyValueRenameInputValidator;

public class YAMLCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final String CONFIG_KEY_SEQUENCE_PATTERN = "\\.*([^\\s{}\\[\\].][^\\s.]*\\.)+[^\\s{}\\[\\].][^\\s.]*:?\\s*";

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int lineNumber;
        int lineStartOffset;
        int indent;
        if (file.getLanguage() != YAMLLanguage.INSTANCE) {
            return text;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        String specialKeyPaste = YAMLCopyPasteProcessor.tryToPasteAsKeySequence(text, file, editor, caretOffset, indent = caretOffset - (lineStartOffset = YAMLTextUtil.getLineStartSafeOffset(document, lineNumber = document.getLineNumber(caretOffset))));
        if (specialKeyPaste != null) {
            return specialKeyPaste;
        }
        if (indent == 0) {
            return text;
        }
        return YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent));
    }

    @NotNull
    private static String indentText(@NotNull String text, @NotNull String curLineIndent) {
        List lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false);
        if (lines.isEmpty()) {
            return text;
        }
        int minIndent = YAMLCopyPasteProcessor.calculateMinBlockIndent(lines);
        String firstLine = (String)lines.iterator().next();
        if (lines.size() == 1) {
            return firstLine;
        }
        return firstLine.substring(YAMLTextUtil.getStartIndentSize(firstLine)) + "\n" + lines.stream().skip(1L).map(line -> {
            if (YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return curLineIndent + line.substring(minIndent);
            }
            return "";
        }).reduce((left, right) -> left + "\n" + right).orElse("");
    }

    private static int calculateMinBlockIndent(@NotNull List<String> list) {
        Iterator<String> it = list.iterator();
        String str = "";
        while (it.hasNext() && !YAMLCopyPasteProcessor.isEmptyLine(str = it.next())) {
        }
        if (!it.hasNext()) {
            return 0;
        }
        int minIndent = YAMLTextUtil.getStartIndentSize(str);
        while (it.hasNext()) {
            str = it.next();
            if (!YAMLCopyPasteProcessor.isEmptyLine(str)) continue;
            minIndent = Math.min(minIndent, YAMLTextUtil.getStartIndentSize(str));
        }
        return minIndent;
    }

    private static boolean isEmptyLine(@NotNull String str) {
        return YAMLTextUtil.getStartIndentSize(str) < str.length();
    }

    @Nullable
    private static String tryToPasteAsKeySequence(@NotNull String text, @NotNull PsiFile file, @NotNull Editor editor, int caretOffset, int indent) {
        String result;
        if (!text.matches(CONFIG_KEY_SEQUENCE_PATTERN)) {
            return null;
        }
        List<String> keys = YAMLCopyPasteProcessor.separateCompositeKey(text);
        assert (!keys.isEmpty());
        for (String key : keys) {
            if (YamlKeyValueRenameInputValidator.IDENTIFIER_PATTERN.matcher(key).matches()) continue;
            return null;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null && (result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent)) != null) {
            return result;
        }
        if ((element == null || element.getTextRange().getStartOffset() == caretOffset) && caretOffset > 0 && (element = file.findElementAt(caretOffset - 1)) != null) {
            int parentIndent;
            result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent);
            if (result != null) {
                return result;
            }
            YAMLKeyValue keyValue = YAMLCopyPasteProcessor.getPreviousKeyValuePairBeforeEOL(element);
            if (keyValue != null && keyValue.getValue() == null && indent > (parentIndent = YAMLUtil.getIndentToThisElement((PsiElement)keyValue))) {
                return YAMLElementGenerator.createChainedKey(keys, indent);
            }
        }
        return null;
    }

    @Nullable
    private static YAMLKeyValue getPreviousKeyValuePairBeforeEOL(@NotNull PsiElement element) {
        PsiElement cur;
        if (PsiUtilCore.getElementType((PsiElement)element.getParent()) != YAMLElementTypes.MAPPING) {
            return null;
        }
        boolean eolMet = false;
        for (cur = element; cur != null && YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)cur)); cur = cur.getPrevSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)cur) != YAMLTokenTypes.EOL) continue;
            eolMet = true;
        }
        if (eolMet && PsiUtilCore.getElementType((PsiElement)cur) == YAMLElementTypes.KEY_VALUE_PAIR) {
            return (YAMLKeyValue)cur;
        }
        return null;
    }

    @Nullable
    private static String tryToPasteAsKeySequenceAtMapping(@NotNull Editor editor, @NotNull List<String> keys, @NotNull PsiElement element, int caretOffset, int indent) {
        while (true) {
            YAMLKeyValue keyValue;
            YAMLBlockMappingImpl blockMapping;
            if (element.getParent() instanceof YAMLFile) {
                PsiElement prev = element.getPrevSibling();
                if (!(prev instanceof YAMLDocument)) {
                    return null;
                }
                element = ((YAMLDocument)prev).getTopLevelValue();
                if (!(element instanceof YAMLBlockMappingImpl)) {
                    return null;
                }
                blockMapping = (YAMLBlockMappingImpl)element;
            } else {
                blockMapping = (YAMLBlockMappingImpl)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLBlockMappingImpl.class);
            }
            if (blockMapping == null) {
                return null;
            }
            int mappingIndent = YAMLUtil.getIndentToThisElement((PsiElement)blockMapping);
            if (mappingIndent == indent && (keyValue = (YAMLKeyValue)ApplicationManager.getApplication().runWriteAction(() -> {
                YAMLKeyValue lastKeyVal = blockMapping.getOrCreateKeySequence(keys, caretOffset);
                if (lastKeyVal == null) {
                    return null;
                }
                ASTNode colon = lastKeyVal.getNode().findChildByType((IElementType)YAMLTokenTypes.COLON);
                if (colon != null) {
                    int newOffset = colon.getTextRange().getEndOffset();
                    editor.getCaretModel().moveToOffset(newOffset);
                }
                return lastKeyVal;
            })) != null) {
                return "";
            }
            element = blockMapping;
        }
    }

    @NotNull
    private static List<String> separateCompositeKey(@NotNull String text) {
        text = text.trim();
        text = StringUtil.trimEnd((String)text, (char)':');
        int leadingDotsNumber = StringUtil.countChars((CharSequence)text, (char)'.', (int)0, (boolean)true);
        String dotPrefix = text.substring(0, leadingDotsNumber);
        text = text.substring(leadingDotsNumber);
        List sequence = StringUtil.split((String)text, (String)".");
        if (!dotPrefix.isEmpty() && sequence.size() > 0) {
            sequence.set(0, dotPrefix + (String)sequence.get(0));
        }
        return sequence;
    }
}

