/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

class YAMLFormattingContext {
    private static final Indent DIRECT_NORMAL_INDENT = Indent.getNormalIndent((boolean)true);
    private static final Indent SAME_AS_PARENT_INDENT = Indent.getSpaceIndent((int)0, (boolean)true);
    private static final Indent SAME_AS_INDENTED_ANCESTOR_INDENT = Indent.getSpaceIndent((int)0);
    @NotNull
    public final CodeStyleSettings mySettings;
    @NotNull
    private final SpacingBuilder mySpaceBuilder;
    @NotNull
    private final Map<ASTNode, Alignment> myChildIndentAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
    @NotNull
    private final Map<ASTNode, Alignment> myChildValueAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
    private final boolean shouldIndentSequenceValue;
    private final boolean shouldInlineSequenceIntoSequence;
    private final boolean shouldInlineBlockMappingIntoSequence;
    private final int getValueAlignment;

    YAMLFormattingContext(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
        this.mySpaceBuilder = new SpacingBuilder(this.mySettings, (Language)YAMLLanguage.INSTANCE).before((IElementType)YAMLTokenTypes.COLON).spaces(0);
        this.shouldIndentSequenceValue = ((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).INDENT_SEQUENCE_VALUE;
        this.shouldInlineSequenceIntoSequence = !((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).SEQUENCE_ON_NEW_LINE;
        this.shouldInlineBlockMappingIntoSequence = !((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).BLOCK_MAPPING_ON_NEW_LINE;
        this.getValueAlignment = ((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).ALIGN_VALUES_PROPERTIES;
    }

    @Nullable
    Spacing computeSpacing(@NotNull Block parent, @Nullable Block child1, @NotNull Block child2) {
        Spacing simpleSpacing = this.mySpaceBuilder.getSpacing(parent, child1, child2);
        if (simpleSpacing != null) {
            return simpleSpacing;
        }
        if (!(child1 instanceof ASTBlock) || !(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode node1 = ((ASTBlock)child1).getNode();
        ASTNode node2 = ((ASTBlock)child2).getNode();
        if (PsiUtilCore.getElementType((ASTNode)node1) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return null;
        }
        IElementType node2Type = PsiUtilCore.getElementType((ASTNode)node2);
        int indentSize = this.mySettings.getIndentSize((FileType)YAMLFileType.YML);
        if (indentSize < 2) {
            indentSize = 2;
        }
        int spaces = 1;
        int minLineFeeds = 0;
        if (node2Type == YAMLElementTypes.SEQUENCE_ITEM) {
            if (this.shouldInlineSequenceIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        } else if (node2Type == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldInlineBlockMappingIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)minLineFeeds, (boolean)false, (int)0);
    }

    @Nullable
    Alignment computeAlignment(@NotNull ASTNode node) {
        ASTNode prev;
        IElementType type = PsiUtilCore.getElementType((ASTNode)node);
        if (type == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (this.getValueAlignment == 2) {
            if (type == YAMLTokenTypes.COLON) {
                return this.myChildValueAlignments.get(node.getTreeParent().getTreeParent());
            }
        } else if (this.getValueAlignment == 1 && YAMLElementTypes.SCALAR_ITEMS.contains(type) && PsiUtilCore.getElementType((ASTNode)(prev = YAMLFormattingContext.getPreviousNonBlankNode(node.getTreeParent()))) == YAMLTokenTypes.COLON) {
            return this.myChildValueAlignments.get(prev.getTreeParent().getTreeParent());
        }
        return null;
    }

    @Nullable
    Indent computeBlockIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType nodeType = PsiUtilCore.getElementType((ASTNode)node);
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        assert (nodeType != YAMLElementTypes.SEQUENCE) : "Sequence should be inlined!";
        assert (nodeType != YAMLElementTypes.MAPPING) : "Mapping should be inlined!";
        assert (nodeType != YAMLElementTypes.DOCUMENT) : "Document should be inlined!";
        if (YAMLElementTypes.DOCUMENT_BRACKETS.contains(nodeType)) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.BRACKETS.contains(nodeType)) {
            return SAME_AS_INDENTED_ANCESTOR_INDENT;
        }
        if (nodeType == YAMLTokenTypes.TEXT) {
            return grandParentIsDocument ? SAME_AS_PARENT_INDENT : DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.FILE) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.SCALAR_VALUES.contains(nodeType)) {
            return DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.computeSequenceItemIndent(node);
        }
        if (nodeType == YAMLElementTypes.KEY_VALUE_PAIR) {
            return YAMLFormattingContext.computeKeyValuePairIndent(node);
        }
        if (nodeType == YAMLTokenTypes.COMMENT) {
            if (parentType == YAMLElementTypes.SEQUENCE) {
                return this.computeSequenceItemIndent(node);
            }
            if (parentType == YAMLElementTypes.MAPPING) {
                return YAMLFormattingContext.computeKeyValuePairIndent(node);
            }
        }
        return YAMLElementTypes.TOP_LEVEL.contains(parentType) ? SAME_AS_PARENT_INDENT : null;
    }

    @Nullable
    Indent computeNewChildIndent(@NotNull ASTNode node) {
        return YAMLElementTypes.TOP_LEVEL.contains(PsiUtilCore.getElementType((ASTNode)node)) ? SAME_AS_PARENT_INDENT : DIRECT_NORMAL_INDENT;
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        YAMLValue value2;
        Predicate<YAMLValue> possiblyIncompleteValue = value -> value == null || YAMLElementTypes.INCOMPLETE_BLOCKS.contains(PsiUtilCore.getElementType((PsiElement)value));
        if (PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.KEY_VALUE_PAIR ? possiblyIncompleteValue.test(value2 = ((YAMLKeyValue)node.getPsi()).getValue()) : PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.SEQUENCE_ITEM && possiblyIncompleteValue.test(value = ((YAMLSequenceItem)node.getPsi()).getValue())) {
            return true;
        }
        return FormatterUtil.isIncomplete((ASTNode)node);
    }

    @Nullable
    private static Indent computeKeyValuePairIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.HASH) {
            return Indent.getNormalIndent();
        }
        if (grandParentIsDocument) {
            return SAME_AS_PARENT_INDENT;
        }
        if (parentType == YAMLElementTypes.SEQUENCE_ITEM) {
            return Indent.getNormalIndent();
        }
        return DIRECT_NORMAL_INDENT;
    }

    @NotNull
    private Indent computeSequenceItemIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.ARRAY) {
            return Indent.getNoneIndent();
        }
        if (grandParentType == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldIndentSequenceValue) {
                return DIRECT_NORMAL_INDENT;
            }
            return SAME_AS_PARENT_INDENT;
        }
        if (grandParentIsDocument) {
            return SAME_AS_PARENT_INDENT;
        }
        return DIRECT_NORMAL_INDENT;
    }

    @Nullable
    private static ASTNode getPreviousNonBlankNode(ASTNode node) {
        do {
            if (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)(node = TreeUtil.prevLeaf((ASTNode)node))))) continue;
            return node;
        } while (node != null);
        return null;
    }
}

