/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.EditorActionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLSequence;

public class YAMLHyphenTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        YAMLHyphenTypedHandler.autoIndentHyphen(c, project, editor, file);
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void autoIndentHyphen(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (c != ' ' || !(file instanceof YAMLFile)) {
            return;
        }
        if (!file.isValid()) {
            return;
        }
        int curPosOffset = editor.getCaretModel().getOffset();
        if (curPosOffset < 2) {
            return;
        }
        int offset = curPosOffset - 2;
        Document document = editor.getDocument();
        if (document.getCharsSequence().charAt(offset) != '-') {
            return;
        }
        if (curPosOffset < document.getTextLength() && document.getCharsSequence().charAt(curPosOffset) != '\n') {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement element = file.findElementAt(offset);
        if (PsiUtilCore.getElementType((PsiElement)element) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return;
        }
        PsiElement item = element.getParent();
        if (PsiUtilCore.getElementType((PsiElement)item) != YAMLElementTypes.SEQUENCE_ITEM) {
            return;
        }
        PsiElement sequence = item.getParent();
        if (PsiUtilCore.getElementType((PsiElement)sequence) != YAMLElementTypes.SEQUENCE) {
            return;
        }
        if (((YAMLSequence)sequence).getItems().size() != 1) {
            return;
        }
        EditorActionManager editorActionManager = EditorActionManager.getInstance();
        if (!(editorActionManager instanceof EditorActionManagerImpl)) {
            return;
        }
        DefaultRawTypedHandler handler = ((EditorActionManagerImpl)editorActionManager).getDefaultRawTypedHandler();
        handler.beginUndoablePostProcessing();
        ApplicationManager.getApplication().runWriteAction(() -> {
            int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
            editor.getCaretModel().moveToOffset(newOffset + 2);
        });
    }
}

