/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer._YAMLLexer;

public class YAMLFlexLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.TEXT});
    private static final int DIRTY_STATE = 239;

    public YAMLFlexLexer() {
        super((Lexer)new MyFlexAdapter(new LexerCustomisation(null)), TOKENS_TO_MERGE);
    }

    private static int calcOffsetFromLineStart(CharSequence buffer, int start) {
        for (int i = start - 1; i >= 0; --i) {
            if (buffer.charAt(i) != '\n') continue;
            return start - i + 1;
        }
        return start;
    }

    private static class MyFlexAdapter
    extends FlexAdapter {
        private boolean myStateCleanliness = false;

        MyFlexAdapter(_YAMLLexer flex) {
            super((FlexLexer)flex);
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (initialState != 239) {
                ((_YAMLLexer)this.getFlex()).cleanMyState();
            } else {
                initialState = 0;
            }
            super.start(buffer, startOffset, endOffset, initialState);
        }

        public int getState() {
            int state = super.getState();
            if (state != 0 || this.myStateCleanliness) {
                return state;
            }
            return 239;
        }

        protected void locateToken() {
            this.myStateCleanliness = ((_YAMLLexer)this.getFlex()).isCleanState();
            super.locateToken();
        }
    }

    private static class LexerCustomisation
    extends _YAMLLexer {
        LexerCustomisation(Reader in) {
            super(in);
        }

        @Override
        public void reset(CharSequence buffer, int start, int end, int initialState) {
            super.reset(buffer, start, end, initialState);
            this.yycolumn = YAMLFlexLexer.calcOffsetFromLineStart(buffer, start);
        }
    }
}

