/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlDebugUtil;
import org.jetbrains.yaml.meta.impl.YamlKeyInsertHandlerImpl;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlMetaTypeCompletionProviderBase
extends CompletionProvider<CompletionParameters> {
    protected static final Logger LOG = Logger.getInstance(YamlMetaTypeCompletionProviderBase.class);

    @Nullable
    protected abstract YamlMetaTypeProvider getMetaTypeProvider(@NotNull CompletionParameters var1);

    protected void addCompletions(@NotNull CompletionParameters params, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        YamlMetaTypeProvider metaTypeProvider = this.getMetaTypeProvider(params);
        if (metaTypeProvider == null) {
            return;
        }
        PsiElement position = params.getPosition();
        if (!YamlMetaTypeCompletionProviderBase.isOfType(position.getParent(), YAMLElementTypes.SCALAR_PLAIN_VALUE)) {
            return;
        }
        YAMLScalar insertedScalar = (YAMLScalar)position.getParent();
        if (insertedScalar.getTextRange().getStartOffset() < params.getOffset()) {
            int positionOffset = params.getOffset() - insertedScalar.getTextRange().getStartOffset();
            assert (positionOffset > 0);
            String combinedText = insertedScalar.getText();
            if (positionOffset >= combinedText.length()) {
                return;
            }
            if (combinedText.charAt(positionOffset - 1) == ':') {
                YamlMetaTypeCompletionProviderBase.trace("Completion rejected: misplaced just after key position : " + YamlDebugUtil.getDebugInfo(position));
                return;
            }
        }
        YamlMetaTypeProvider.MetaTypeProxy meta = metaTypeProvider.getMetaTypeProxy((PsiElement)insertedScalar);
        YamlMetaTypeCompletionProviderBase.trace("meta: " + meta);
        if (meta == null) {
            return;
        }
        YamlMetaType metaType = meta.getMetaType();
        if (params.getCompletionType().equals((Object)CompletionType.BASIC) && metaType instanceof YamlScalarType) {
            YamlScalarType scalarType = (YamlScalarType)metaType;
            if (insertedScalar.getParent() instanceof YAMLKeyValue) {
                PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)insertedScalar);
                if (YamlMetaTypeCompletionProviderBase.isOfType(prevSibling, YAMLTokenTypes.COLON)) {
                    prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prevSibling);
                }
                if (YamlMetaTypeCompletionProviderBase.isOfType(prevSibling, YAMLTokenTypes.SCALAR_KEY)) {
                    YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, scalarType, result, Collections.emptyMap());
                    return;
                }
            }
            if (insertedScalar.getParent() instanceof YAMLSequenceItem) {
                YAMLSequenceItem currentItem = (YAMLSequenceItem)insertedScalar.getParent();
                List siblingItems = Optional.ofNullable(currentItem.getParent()).filter(YAMLSequence.class::isInstance).map(YAMLSequence.class::cast).map(YAMLSequence::getItems).orElse(Collections.emptyList());
                Map<String, YAMLScalar> siblingValues = siblingItems.stream().filter(i -> i.getKeysValues().isEmpty()).filter(i -> !currentItem.equals(i)).map(YAMLSequenceItem::getValue).filter(Objects::nonNull).filter(YAMLScalar.class::isInstance).map(YAMLScalar.class::cast).collect(Collectors.toMap(scalar -> scalar.getText().trim(), scalar -> scalar, (oldVal, newVal) -> newVal));
                YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, scalarType, result, siblingValues);
                return;
            }
        }
        if (metaType instanceof YamlMetaClass) {
            YamlMetaTypeCompletionProviderBase.addKeyCompletions(params, metaTypeProvider, meta, result, (PsiElement)insertedScalar);
        }
    }

    private static void addKeyCompletions(@NotNull CompletionParameters params, @NotNull YamlMetaTypeProvider metaTypeProvider, @NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull CompletionResultSet result, @NotNull PsiElement insertedScalar) {
        boolean needsSequenceItemMark;
        if (!(meta.getMetaType() instanceof YamlMetaClass)) {
            return;
        }
        YamlMetaClass metaClass = (YamlMetaClass)meta.getMetaType();
        YAMLValue metaOwner = metaTypeProvider.getMetaOwner(insertedScalar);
        if (metaOwner instanceof YAMLScalar && metaOwner.getParent() instanceof YAMLMapping) {
            metaOwner = (YAMLValue)metaOwner.getParent();
        }
        Collection existingPairs = Optional.ofNullable(metaOwner).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast).map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
        Map<String, YAMLKeyValue> existingByKey = existingPairs.stream().collect(Collectors.toMap(kv -> kv.getKeyText().trim(), kv -> kv, (oldValue, newValue) -> oldValue));
        List fieldList = ContainerUtil.filter(metaClass.getFeatures(), childField -> !existingByKey.containsKey(childField.getName()) && childField.isEditable());
        boolean bl = needsSequenceItemMark = existingPairs.isEmpty() && YamlMetaTypeCompletionProviderBase.needsSequenceItem(meta.getField());
        if (params.getCompletionType() == CompletionType.SMART) {
            String text = insertedScalar.getText();
            int caretPos = text.indexOf(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
            String pattern = (caretPos >= 0 ? text.substring(0, caretPos) : text).toLowerCase();
            Collection<List<Field>> paths = YamlMetaTypeCompletionProviderBase.collectPaths(fieldList, pattern.length() > 0 ? 10 : 1);
            for (List<Field> pathToInsert : paths) {
                Field lastField = pathToInsert.get(pathToInsert.size() - 1);
                if (!lastField.getName().toLowerCase().startsWith(pattern)) continue;
                YamlMetaType.ForcedCompletionPath completionPath = YamlMetaType.ForcedCompletionPath.forDeepCompletion(pathToInsert);
                LookupElementBuilder l = LookupElementBuilder.create((Object)completionPath, (String)completionPath.getName()).withIcon(lastField.getLookupIcon()).withInsertHandler((InsertHandler)new YamlKeyInsertHandlerImpl(needsSequenceItemMark, pathToInsert.get(0))).withTypeText(lastField.getDefaultType().getDisplayName(), true).withStrikeoutness(lastField.isDeprecated());
                result.addElement((LookupElement)l);
            }
        } else {
            fieldList.stream().filter(childField -> !existingByKey.containsKey(childField.getName())).forEach(childField -> YamlMetaTypeCompletionProviderBase.registerBasicKeyCompletion(metaClass, childField, result, insertedScalar, needsSequenceItemMark));
        }
    }

    private static boolean needsSequenceItem(@NotNull Field parentField) {
        return parentField.isMany() && !parentField.hasRelationSpecificType(Field.Relation.OBJECT_CONTENTS);
    }

    private static void registerBasicKeyCompletion(@NotNull YamlMetaClass metaClass, @NotNull Field toBeInserted, @NotNull CompletionResultSet result, @NotNull PsiElement insertedScalar, boolean needsSequenceItemMark) {
        List<LookupElementBuilder> lookups = toBeInserted.getKeyLookups(metaClass, insertedScalar);
        if (!lookups.isEmpty()) {
            YamlKeyInsertHandlerImpl keyInsertHandler = new YamlKeyInsertHandlerImpl(needsSequenceItemMark, toBeInserted);
            lookups.stream().map(l -> l.withInsertHandler(keyInsertHandler)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }
    }

    @NotNull
    private static Collection<List<Field>> collectPaths(@NotNull Collection<Field> fields, int deepness) {
        ArrayList<List<Field>> result = new ArrayList<List<Field>>();
        YamlMetaTypeCompletionProviderBase.doCollectPathsRec(fields, Collections.emptyList(), result, deepness);
        return result;
    }

    private static void doCollectPathsRec(@NotNull Collection<Field> fields, @NotNull List<Field> currentPath, @NotNull Collection<List<Field>> result, int deepness) {
        if (currentPath.size() >= deepness) {
            return;
        }
        fields.stream().filter(field -> !field.isAnyNameAllowed()).forEach(field -> {
            List fieldPath = StreamEx.of((Collection)currentPath).append(field).toList();
            result.add(fieldPath);
            YamlMetaType metaType = field.getType(field.getDefaultRelation());
            if (metaType instanceof YamlMetaClass) {
                YamlMetaTypeCompletionProviderBase.doCollectPathsRec(ContainerUtil.filter(((YamlMetaClass)metaType).getFeatures(), Field::isEditable), fieldPath, result, deepness);
            }
        });
    }

    private static void addValueCompletions(@NotNull YAMLScalar insertedScalar, @NotNull YamlScalarType meta, @NotNull CompletionResultSet result, @NotNull Map<String, YAMLScalar> siblings) {
        meta.getValueLookups(insertedScalar).stream().filter(lookup -> !siblings.containsKey(lookup.getLookupString())).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    private static void trace(String text) {
        LOG.trace(text);
    }

    private static boolean isOfType(@Nullable PsiElement psi, @NotNull IElementType type) {
        return psi != null && psi.getNode().getElementType() == type;
    }
}

