/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@ApiStatus.Experimental
public abstract class YamlMissingKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        return new StructureChecker(holder, metaTypeProvider);
    }

    @NotNull
    protected PsiElement getElementToHighlight(@NotNull YAMLMapping mapping) {
        PsiElement parent = mapping.getParent();
        if (parent instanceof YAMLDocument) {
            return parent;
        }
        if (parent instanceof YAMLSequenceItem) {
            PsiElement key = parent.getFirstChild();
            return key != null ? key : mapping;
        }
        if (parent instanceof YAMLKeyValue) {
            PsiElement key = ((YAMLKeyValue)parent).getKey();
            return key != null ? key : mapping;
        }
        return mapping;
    }

    @NotNull
    private static String composeKeyList(@NotNull Collection<String> missingKeys) {
        return String.join((CharSequence)", ", missingKeys);
    }

    @NotNull
    private static Collection<String> getMissingKeys(@NotNull YAMLMapping mapping, @NotNull YamlMetaClass metaClass) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        Set keySet = mapping.getKeyValues().stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet());
        for (Field feature : metaClass.getFeatures()) {
            if (!feature.isRequired() || keySet.contains(feature.getName())) continue;
            missingKeys.add(feature.getName());
        }
        return missingKeys;
    }

    private static class AddMissingKeysQuickFix
    implements LocalQuickFix {
        private final Collection<String> myMissingKeys;
        private final SmartPsiElementPointer<YAMLMapping> myMappingHolder;

        AddMissingKeysQuickFix(@NotNull Collection<String> missingKeys, @NotNull YAMLMapping mapping) {
            this.myMissingKeys = missingKeys;
            this.myMappingHolder = SmartPointerManager.getInstance((Project)mapping.getProject()).createSmartPsiElementPointer((PsiElement)mapping);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return YAMLBundle.message("YamlMissingKeysInspectionBase.add.missing.keys.quickfix.name");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLElementGenerator elementGenerator = YAMLElementGenerator.getInstance(project);
            PsiElement mapping = this.myMappingHolder.getElement();
            if (mapping == null) {
                return;
            }
            for (String missingKey : this.myMissingKeys) {
                mapping.add(elementGenerator.createEol());
                mapping.add(elementGenerator.createIndent(YAMLUtil.getIndentToThisElement(mapping)));
                mapping.add((PsiElement)elementGenerator.createYamlKeyValue(missingKey, ""));
            }
        }
    }

    protected class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public StructureChecker(@NotNull ProblemsHolder problemsHolder, YamlMetaTypeProvider metaTypeProvider) {
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getMetaTypeProxy((PsiElement)mapping);
            if (meta == null) {
                return;
            }
            YamlMetaType metaType = meta.getMetaType();
            if (!(metaType instanceof YamlMetaClass)) {
                return;
            }
            Collection missingKeys = YamlMissingKeysInspectionBase.getMissingKeys(mapping, (YamlMetaClass)metaType);
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message("YamlMissingKeysInspectionBase.missing.keys", YamlMissingKeysInspectionBase.composeKeyList(missingKeys));
                this.myProblemsHolder.registerProblem(YamlMissingKeysInspectionBase.this.getElementToHighlight(mapping), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddMissingKeysQuickFix(missingKeys, mapping)});
            }
        }
    }
}

