/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlUnknownValuesInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        return new ValuesChecker(holder, metaTypeProvider);
    }

    protected static class ValuesChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public ValuesChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue.getKey() == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta == null) {
                return;
            }
            YAMLValue value = keyValue.getValue();
            if (value == null) {
                this.validateEmptyValue(meta.getField(), keyValue);
                return;
            }
            this.validateMultiplicity(meta, value);
            meta.getMetaType().validateKeyValue(keyValue, this.myProblemsHolder);
        }

        protected void validateMultiplicity(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta.getField().isMany()) {
                this.requireMultiplicityMany(value);
            } else if (!meta.getField().hasRelationSpecificType(Field.Relation.SEQUENCE_ITEM)) {
                this.requireMultiplicityOne(value);
            }
        }

        protected void requireMultiplicityOne(@NotNull YAMLValue value) {
            if (value instanceof YAMLSequence) {
                for (YAMLSequenceItem next : ((YAMLSequence)value).getItems()) {
                    if (next.getValue() == null || !next.getKeysValues().isEmpty()) continue;
                    this.myProblemsHolder.registerProblem((PsiElement)next.getValue(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.not.allowed", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        protected void requireMultiplicityMany(@NotNull YAMLValue value) {
            if (value instanceof YAMLScalar) {
                this.myProblemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.is.required", new Object[0]), new LocalQuickFix[0]);
            }
        }

        protected void validateEmptyValue(@NotNull Field feature, @NotNull YAMLKeyValue withoutValue) {
            assert (withoutValue.getKey() != null);
            if (!feature.isEmptyValueAllowed() && !feature.isAnyValueAllowed()) {
                InspectionManager manager = this.myProblemsHolder.getManager();
                ProblemDescriptor eolError = manager.createProblemDescriptor(withoutValue.getKey(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.value.is.required", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myProblemsHolder.isOnTheFly(), true);
                this.myProblemsHolder.registerProblem(eolError);
            }
        }
    }
}

