/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.YamlEnumType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlBooleanType
extends YamlEnumType {
    public static YamlBooleanType getSharedInstance() {
        return StandardYamlBoolean.SHARED;
    }

    public YamlBooleanType(@NotNull String name) {
        super(name);
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue instanceof YAMLQuotedText) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlBooleanType.validation.error.quoted.value", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            return;
        }
        super.validateScalarValue(scalarValue, holder);
    }

    public static class LiteralBuilder {
        private final Set<String> myResult = new LinkedHashSet<String>();

        public LiteralBuilder withAllCasesOf(String ... literals) {
            for (String next : literals) {
                if (next == null) continue;
                this.withLiteral(next, LiteralBuilder::lower, LiteralBuilder::CAPS, LiteralBuilder::First);
            }
            return this;
        }

        public LiteralBuilder withLiteral(@NotNull String literal, Function<String, String> ... capitalizations) {
            if (capitalizations.length == 0) {
                this.myResult.add(literal);
            } else {
                for (Function<String, String> next : capitalizations) {
                    this.myResult.add(next.apply(literal));
                }
            }
            return this;
        }

        public String[] toArray() {
            return ArrayUtil.toStringArray(this.myResult);
        }

        @NotNull
        protected static String lower(@NotNull String text) {
            return text.toLowerCase(Locale.ENGLISH);
        }

        @NotNull
        protected static String CAPS(@NotNull String text) {
            return text.toUpperCase(Locale.ENGLISH);
        }

        @NotNull
        protected static String First(@NotNull String text) {
            return StringUtil.toTitleCase((String)text);
        }
    }

    private static class StandardYamlBoolean
    extends YamlBooleanType {
        private static final StandardYamlBoolean SHARED = new StandardYamlBoolean();

        StandardYamlBoolean() {
            super("yaml:boolean");
            this.setDisplayName("boolean");
            this.withLiterals("true", "false");
            this.withHiddenLiterals(new LiteralBuilder().withLiteral("true", LiteralBuilder::CAPS, LiteralBuilder::First).withLiteral("false", LiteralBuilder::CAPS, LiteralBuilder::First).withAllCasesOf("on", "off", "yes", "no").toArray());
        }
    }
}

