/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlIntegerType
extends YamlScalarType {
    private static final YamlIntegerType SHARED_INSTANCE_NO_QUOTED_VALUES_ALLOWED = new YamlIntegerType(false);
    private static final YamlIntegerType SHARED_INSTANCE_QUOTED_VALUES_ALLOWED = new YamlIntegerType(true);
    private final boolean myQuotedValuesAllowed;

    public static YamlIntegerType getInstance(boolean quotedValuesAllowed) {
        return quotedValuesAllowed ? SHARED_INSTANCE_QUOTED_VALUES_ALLOWED : SHARED_INSTANCE_NO_QUOTED_VALUES_ALLOWED;
    }

    public YamlIntegerType(boolean quotedValuesAllowed) {
        super("yaml:integer");
        this.myQuotedValuesAllowed = quotedValuesAllowed;
        this.setDisplayName("integer");
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        try {
            if (!this.myQuotedValuesAllowed && scalarValue instanceof YAMLQuotedText) {
                throw new NumberFormatException("no quoted values allowed");
            }
            Integer.parseInt(scalarValue.getTextValue());
        }
        catch (NumberFormatException e) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlIntegerType.error.integer.value"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }
}

