/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlScalarType
extends YamlMetaType {
    protected YamlScalarType(@NotNull String typeName) {
        super(typeName);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return PlatformIcons.PROPERTY_ICON;
    }

    @Override
    public void validateKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        YAMLValue value = keyValue.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof YAMLScalar) {
            this.validateScalarValue((YAMLScalar)value, problemsHolder);
        } else if (value instanceof YAMLSequence) {
            for (YAMLSequenceItem nextItem : ((YAMLSequence)value).getItems()) {
                YAMLValue nextValue = nextItem.getValue();
                if (!(nextValue instanceof YAMLScalar)) continue;
                this.validateScalarValue((YAMLScalar)nextValue, problemsHolder);
            }
        } else if (value instanceof YAMLCompoundValue) {
            problemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlScalarType.error.scalar.value"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
    }

    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar context) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        switch (relation) {
            case OBJECT_CONTENTS: 
            case SCALAR_VALUE: {
                markup.append(": ");
                if (!iteration.isEndOfPathReached()) break;
                markup.appendCaret();
                break;
            }
            case SEQUENCE_ITEM: {
                markup.append(":");
                markup.increaseTabs(2);
                try {
                    markup.newLineAndTabs(true);
                    if (!iteration.isEndOfPathReached()) break;
                    markup.appendCaret();
                    break;
                }
                finally {
                    markup.decreaseTabs(2);
                }
            }
            default: {
                throw new IllegalStateException("Unknown relation: " + (Object)((Object)relation));
            }
        }
    }
}

