/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;

class YAMLKeyNavigationItem
implements NavigationItem {
    @NotNull
    private final Navigatable myNavigatable;
    @NotNull
    private final String myName;
    @NotNull
    private final VirtualFile myFile;

    YAMLKeyNavigationItem(@NotNull Navigatable navigatable, @NotNull String name, @NotNull VirtualFile file) {
        this.myNavigatable = navigatable;
        this.myName = name;
        this.myFile = file;
    }

    public void navigate(boolean requestFocus) {
        this.myNavigatable.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                return YAMLKeyNavigationItem.this.myName;
            }

            @NotNull
            public String getLocationString() {
                return YAMLKeyNavigationItem.this.myFile.toString();
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                return YAMLKeyValueImpl.YAML_KEY_ICON;
            }
        };
    }
}

