/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YAMLKeysIndex;

public class YAMLKeysSearchEverywhereContributor
implements SearchEverywhereContributor<Language> {
    @Nullable
    final Project myProject;

    public YAMLKeysSearchEverywhereContributor(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        return this.getClass().getSimpleName();
    }

    @NotNull
    public String getGroupName() {
        return YAMLBundle.message("YAMLKeysSearchEverywhereContributor.group.name");
    }

    public String includeNonProjectItemsText() {
        return null;
    }

    public int getSortWeight() {
        return 1000;
    }

    public boolean showInFindResults() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Language> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (this.myProject == null || pattern.isEmpty()) {
            return;
        }
        Runnable task = () -> this.findKeys(consumer, pattern, everywhere, progressIndicator);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            application.runReadAction(task);
        } else {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)task, (ProgressIndicator)progressIndicator);
        }
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        if (selected instanceof Navigatable) {
            ((Navigatable)selected).navigate(true);
        }
        return true;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list) {
        return new NavigationItemListCellRenderer();
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        return null;
    }

    private void findKeys(@NotNull Function<Object, Boolean> consumer, @NotNull String pattern, boolean everywhere, ProgressIndicator progressIndicator) {
        if (ActionUtil.isDumbMode((Project)this.myProject)) {
            return;
        }
        assert (this.myProject != null);
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(YAMLKeysIndex.KEY, this.myProject);
        List<String> sorted = YAMLKeysSearchEverywhereContributor.applyPattern(allKeys, pattern, progressIndicator);
        for (String name : sorted) {
            progressIndicator.checkCanceled();
            CommonProcessors.CollectProcessor files = new CommonProcessors.CollectProcessor();
            GlobalSearchScope filter = everywhere ? ProjectScope.getAllScope((Project)this.myProject) : ProjectScope.getProjectScope((Project)this.myProject);
            FileBasedIndex.getInstance().getFilesWithKey(YAMLKeysIndex.KEY, Collections.singleton(name), (Processor)files, filter);
            for (VirtualFile file : files.getResults()) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile == null) continue;
                ArrayList positions = FileBasedIndex.getInstance().getValues(YAMLKeysIndex.KEY, (Object)name, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file));
                if (positions.size() > 1) {
                    positions = new ArrayList(positions);
                    Collections.sort(positions);
                }
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, pos);
                    if (consumer.apply(new YAMLKeyNavigationItem(navigatable, name, file)).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    private static List<String> applyPattern(@NotNull Collection<String> keys, @NotNull String pattern, ProgressIndicator progressIndicator) {
        MultiMap priority = MultiMap.create();
        for (String key : keys) {
            progressIndicator.checkCanceled();
            int start = key.indexOf(pattern);
            if (start == -1 || start > 0 && key.charAt(start - 1) != '.' || start + pattern.length() < key.length() && key.indexOf(".", start + pattern.length()) != -1) continue;
            int dots = YAMLKeysSearchEverywhereContributor.countDots(key, start);
            priority.putValue((Object)dots, (Object)key);
        }
        progressIndicator.checkCanceled();
        return priority.keySet().stream().sorted().map(idx -> priority.get(idx)).map(found -> found.stream().sorted()).flatMap(s -> s).collect(Collectors.toList());
    }

    @Contract(pure=true)
    private static int countDots(@NotNull String path, int end) {
        int count = 0;
        for (int i = 0; i < end; ++i) {
            if (path.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Language> {
        @NotNull
        public SearchEverywhereContributor<Language> createContributor(AnActionEvent initEvent) {
            return new YAMLKeysSearchEverywhereContributor(initEvent.getProject());
        }

        @Nullable
        public SearchEverywhereContributorFilter<Language> createFilter(AnActionEvent initEvent) {
            return null;
        }
    }
}

