/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;

public class YAMLKeyValueImpl
extends YAMLPsiElementImpl
implements YAMLKeyValue {
    public static final Icon YAML_KEY_ICON = PlatformIcons.PROPERTY_ICON;

    public YAMLKeyValueImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String toString() {
        return "YAML key value";
    }

    @Override
    @Nullable
    public PsiElement getKey() {
        PsiElement colon = this.findChildByType(YAMLTokenTypes.COLON);
        if (colon == null) {
            return null;
        }
        ASTNode node = colon.getNode();
        while (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)(node = node.getTreePrev())))) {
        }
        if (node == null || PsiUtilCore.getElementType((ASTNode)node) == YAMLTokenTypes.QUESTION) {
            return null;
        }
        return node.getPsi();
    }

    @Override
    @Nullable
    public YAMLMapping getParentMapping() {
        return (YAMLMapping)ObjectUtils.tryCast((Object)super.getParent(), YAMLMapping.class);
    }

    @Nullable
    public String getName() {
        return this.getKeyText();
    }

    @Override
    @NotNull
    public String getKeyText() {
        PsiElement keyElement = this.getKey();
        if (keyElement == null) {
            return "";
        }
        if (keyElement instanceof YAMLScalar) {
            return ((YAMLScalar)keyElement).getTextValue();
        }
        if (keyElement instanceof YAMLCompoundValue) {
            return ((YAMLCompoundValue)keyElement).getTextValue();
        }
        String text = keyElement.getText();
        return StringUtil.unquoteString((String)text);
    }

    @Override
    @Nullable
    public YAMLValue getValue() {
        for (PsiElement child = this.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) == YAMLTokenTypes.COLON) {
                return null;
            }
            if (!(child instanceof YAMLValue)) continue;
            return (YAMLValue)child;
        }
        return null;
    }

    @Override
    @NotNull
    public String getValueText() {
        YAMLValue value = this.getValue();
        if (value instanceof YAMLScalar) {
            return ((YAMLScalar)value).getTextValue();
        }
        if (value instanceof YAMLCompoundValue) {
            return ((YAMLCompoundValue)value).getTextValue();
        }
        return "";
    }

    @Override
    public void setValue(@NotNull YAMLValue value) {
        this.adjustWhitespaceToContentType(value instanceof YAMLScalar);
        if (this.getValue() != null) {
            this.getValue().replace((PsiElement)value);
            return;
        }
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
        if (this.isExplicit()) {
            if (this.findChildByType(YAMLTokenTypes.COLON) == null) {
                this.add(generator.createColon());
                this.add(generator.createSpace());
                this.add((PsiElement)value);
            }
        } else {
            this.add((PsiElement)value);
        }
    }

    private void adjustWhitespaceToContentType(boolean isScalar) {
        assert (this.getKey() != null);
        PsiElement key = this.getKey();
        if (key.getNextSibling() != null && key.getNextSibling().getNode().getElementType() == YAMLTokenTypes.COLON) {
            key = key.getNextSibling();
        }
        while (key.getNextSibling() != null && !(key.getNextSibling() instanceof YAMLValue)) {
            key.getNextSibling().delete();
        }
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
        if (isScalar) {
            this.addAfter(generator.createSpace(), key);
        } else {
            int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
            this.addAfter(generator.createIndent(indent + 2), key);
            this.addAfter(generator.createEol(), key);
        }
    }

    @NotNull
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        return YAML_KEY_ICON;
    }

    public ItemPresentation getPresentation() {
        ItemPresentation custom = ItemPresentationProviders.getItemPresentation((NavigationItem)this);
        if (custom != null) {
            return custom;
        }
        YAMLFile yamlFile = (YAMLFile)this.getContainingFile();
        YAMLValue value = this.getValue();
        return new ItemPresentation((PsiElement)value, yamlFile){
            final /* synthetic */ PsiElement val$value;
            final /* synthetic */ YAMLFile val$yamlFile;
            {
                this.val$value = psiElement;
                this.val$yamlFile = yAMLFile;
            }

            public String getPresentableText() {
                if (this.val$value instanceof YAMLScalar) {
                    return YAMLKeyValueImpl.this.getValueText();
                }
                return YAMLKeyValueImpl.this.getName();
            }

            public String getLocationString() {
                return "[" + this.val$yamlFile.getName() + "]";
            }

            public Icon getIcon(boolean open) {
                return YAMLKeyValueImpl.this.getIcon(0);
            }
        };
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        return YAMLUtil.rename(this, newName);
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
    }

    private boolean isExplicit() {
        ASTNode child = this.getNode().getFirstChildNode();
        return child != null && child.getElementType() == YAMLTokenTypes.QUESTION;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitKeyValue(this);
        } else {
            super.accept(visitor);
        }
    }
}

