/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLScalarElementManipulator
extends AbstractElementManipulator<YAMLScalarImpl> {
    @NotNull
    public TextRange getRangeInElement(@NotNull YAMLScalarImpl element) {
        List<TextRange> ranges = element.getContentRanges();
        if (ranges.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        return TextRange.create((int)ranges.get(0).getStartOffset(), (int)ranges.get(ranges.size() - 1).getEndOffset());
    }

    public YAMLScalarImpl handleContentChange(@NotNull YAMLScalarImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        try {
            List<Pair<TextRange, String>> encodeReplacements = element.getEncodeReplacements(newContent);
            StringBuilder builder = new StringBuilder();
            String oldText = element.getText();
            builder.append(oldText.subSequence(0, range.getStartOffset()));
            builder.append(YAMLScalarImpl.processReplacements(newContent, encodeReplacements));
            builder.append(oldText.subSequence(range.getEndOffset(), oldText.length()));
            YAMLFile dummyYamlFile = YAMLElementGenerator.getInstance(element.getProject()).createDummyYamlWithText(builder.toString());
            YAMLScalar newScalar = (YAMLScalar)PsiTreeUtil.collectElementsOfType((PsiElement)dummyYamlFile, (Class[])new Class[]{YAMLScalar.class}).iterator().next();
            PsiElement result = element.replace((PsiElement)newScalar);
            if (!(result instanceof YAMLScalarImpl)) {
                throw new AssertionError((Object)"Inserted YAML scalar, but it isn't a scalar after insertion :(");
            }
            return (YAMLScalarImpl)result;
        }
        catch (IllegalArgumentException e) {
            PsiElement newElement = element.replace((PsiElement)YAMLElementGenerator.getInstance(element.getProject()).createYamlDoubleQuotedString());
            if (!(newElement instanceof YAMLQuotedTextImpl)) {
                throw new AssertionError((Object)"Could not replace with dummy scalar");
            }
            return (YAMLScalarImpl)this.handleContentChange((PsiElement)((YAMLScalarImpl)newElement), newContent);
        }
    }
}

