/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public class YAMLLocalResolveUtil {
    private YAMLLocalResolveUtil() {
    }

    @NotNull
    public static Map<YAMLAlias, YAMLAnchor> getResolveAliasMap(@NotNull PsiFile file) {
        return YAMLLocalResolveUtil.getResolveData((PsiFile)file).myResolveMap;
    }

    @NotNull
    public static Collection<YAMLAnchor> getFirstAnchorDefs(@NotNull PsiFile file) {
        return YAMLLocalResolveUtil.getResolveData((PsiFile)file).myFirstDefs;
    }

    @NotNull
    private static YAMLAliasResolveResult getResolveData(@NotNull PsiFile file) {
        return (YAMLAliasResolveResult)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            THashMap resolveMap = new THashMap();
            final HashMap defMap = new HashMap();
            final HashMap firstDefMap = new HashMap();
            file.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor((Map)resolveMap){
                final /* synthetic */ Map val$resolveMap;
                {
                    this.val$resolveMap = map3;
                }

                @Override
                public void visitAnchor(@NotNull YAMLAnchor anchor) {
                    defMap.put(anchor.getName(), anchor);
                    firstDefMap.putIfAbsent(anchor.getName(), anchor);
                }

                @Override
                public void visitAlias(@NotNull YAMLAlias alias) {
                    String name = alias.getAliasName();
                    YAMLAnchor anchor = (YAMLAnchor)defMap.get(name);
                    if (anchor != null) {
                        this.val$resolveMap.put(alias, anchor);
                    }
                }
            });
            THashSet firstDefs = new THashSet(firstDefMap.values());
            YAMLAliasResolveResult result = new YAMLAliasResolveResult((Map<YAMLAlias, YAMLAnchor>)resolveMap, (Set<YAMLAnchor>)firstDefs);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file});
        });
    }

    private static class YAMLAliasResolveResult {
        @NotNull
        final Map<YAMLAlias, YAMLAnchor> myResolveMap;
        @NotNull
        final Set<YAMLAnchor> myFirstDefs;

        YAMLAliasResolveResult(@NotNull Map<YAMLAlias, YAMLAnchor> map, @NotNull Set<YAMLAnchor> firstDefs) {
            this.myResolveMap = Collections.unmodifiableMap(map);
            this.myFirstDefs = Collections.unmodifiableSet(firstDefs);
        }
    }
}

