/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.schema.YamlJsonSchemaInspectionBase;

public class YamlJsonSchemaHighlightingInspection
extends YamlJsonSchemaInspectionBase {
    public boolean myCaseInsensitiveEnum = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        return YAMLBundle.message("inspections.schema.validation.name");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message((String)"json.schema.inspection.case.insensitive.enum", (Object[])new Object[0]), "myCaseInsensitiveEnum");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session, final PsiElement root, final JsonSchemaObject object) {
        final JsonComplianceCheckerOptions options = new JsonComplianceCheckerOptions(this.myCaseInsensitiveEnum);
        return new YamlPsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element != root) {
                    return;
                }
                JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)element, (JsonSchemaObject)object);
                if (walker == null) {
                    return;
                }
                new JsonSchemaComplianceChecker(object, holder, walker, session, options, "Schema validation: ").annotate(element);
            }
        };
    }
}

