/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.schema.YamlJsonPsiWalker;

public abstract class YamlJsonSchemaInspectionBase
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        VirtualFile virtualFile;
        PsiFile file = holder.getFile();
        if (!(file instanceof YAMLFile)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        PsiElement root = YamlJsonPsiWalker.INSTANCE.getRoot(file);
        if (root == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get((Project)file.getProject());
        if (!service.isApplicableToFile(virtualFile = file.getViewProvider().getVirtualFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(file);
        if (rootSchema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return this.doBuildVisitor(holder, session, root, rootSchema);
    }

    protected abstract PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder var1, @NotNull LocalInspectionToolSession var2, PsiElement var3, JsonSchemaObject var4);
}

