/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlObjectAdapter
implements JsonObjectValueAdapter {
    @NotNull
    private final YAMLMapping myObject;
    @NotNull
    private final NotNullLazyValue<List<JsonPropertyAdapter>> myChildAdapters = new NotNullLazyValue<List<JsonPropertyAdapter>>(){

        @NotNull
        protected List<JsonPropertyAdapter> compute() {
            return YamlObjectAdapter.this.computeChildAdapters();
        }
    };

    public YamlObjectAdapter(@NotNull YAMLMapping object) {
        this.myObject = object;
    }

    public boolean isObject() {
        PsiElement tag = this.myObject.getTag();
        return tag == null || "!!map".equals(tag.getText());
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.myObject;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return true;
    }

    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        return (List)this.myChildAdapters.getValue();
    }

    @NotNull
    private List<JsonPropertyAdapter> computeChildAdapters() {
        Collection<YAMLKeyValue> keyValues = this.myObject.getKeyValues();
        ArrayList adapters = ContainerUtil.newArrayListWithCapacity((int)keyValues.size());
        for (YAMLKeyValue value : keyValues) {
            if (this.addPropertiesFromReferencedObject(adapters, value)) continue;
            adapters.add(new YamlPropertyAdapter((PsiElement)value));
        }
        return adapters;
    }

    private boolean addPropertiesFromReferencedObject(List<JsonPropertyAdapter> adapters, YAMLKeyValue value) {
        String keyText = value.getKeyText();
        if (!"<<".equals(keyText)) {
            return false;
        }
        YAMLValue yamlValue = value.getValue();
        PsiElement resolved = YamlObjectAdapter.resolveYamlAlias(yamlValue);
        if (resolved != null) {
            YAMLMapping mapping = (YAMLMapping)ObjectUtils.tryCast((Object)resolved, YAMLMapping.class);
            if (mapping == null) {
                return false;
            }
            List propertyAdapters = (List)RecursionManager.doPreventingRecursion((Object)this.myObject, (boolean)false, () -> new YamlObjectAdapter(mapping).getPropertyList());
            if (propertyAdapters != null) {
                adapters.addAll(propertyAdapters);
                return true;
            }
        }
        if (yamlValue instanceof YAMLMapping) {
            if (PsiTreeUtil.getChildOfType((PsiElement)yamlValue, YAMLAnchor.class) == null) {
                return false;
            }
            adapters.addAll(new YamlObjectAdapter((YAMLMapping)yamlValue).getPropertyList());
            return true;
        }
        return false;
    }

    @Nullable
    static PsiElement resolveYamlAlias(YAMLValue yamlValue) {
        PsiReference reference = yamlValue instanceof YAMLAlias ? yamlValue.getReference() : null;
        PsiElement resolved = reference == null ? null : reference.resolve();
        resolved = resolved == null ? null : resolved.getParent();
        return resolved;
    }
}

