/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DuplicatedPsiTreeElementBase<T extends PsiElement & Navigatable>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    @NotNull
    private final StoredData<T> myValue;

    protected DuplicatedPsiTreeElementBase(@NotNull T psiElement, @NotNull String details) {
        this.myValue = new StoredData<Navigatable>((Navigatable)psiElement, details);
    }

    @NotNull
    public final T getElement() {
        return (T)((PsiElement)((StoredData)this.getValue()).getElement());
    }

    @NotNull
    public final String getDetails() {
        return ((StoredData)this.getValue()).getDetails();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public Object getKey() {
        return String.valueOf(this.getElement());
    }

    @Contract(pure=true)
    @NotNull
    public final StoredData<T> getValue() {
        return this.myValue;
    }

    public String toString() {
        return this.getElement().toString();
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        return (StructureViewTreeElement[])AbstractTreeUi.calculateYieldingToWriteAction(this::doGetChildren);
    }

    @NotNull
    private StructureViewTreeElement[] doGetChildren() {
        return PsiTreeElementBase.mergeWithExtensions(this.getElement(), this.getChildrenBase());
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getElement()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.getElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicatedPsiTreeElementBase that = (DuplicatedPsiTreeElementBase)o;
        return ((StoredData)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        return ((StoredData)this.getValue()).hashCode();
    }

    public boolean isValid() {
        return true;
    }

    private static class StoredData<T extends Navigatable>
    implements Navigatable {
        @NotNull
        private final T myElement;
        @NotNull
        private final String myDetails;

        StoredData(@NotNull T element, @NotNull String details) {
            this.myElement = element;
            this.myDetails = details;
        }

        @NotNull
        public T getElement() {
            return this.myElement;
        }

        @NotNull
        public String getDetails() {
            return this.myDetails;
        }

        public void navigate(boolean requestFocus) {
            this.getElement().navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.getElement().canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.getElement().canNavigateToSource();
        }

        @Contract(value="null -> false", pure=true)
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredData data = (StoredData)o;
            return Objects.equals(this.getElement(), data.getElement()) && Objects.equals(this.getDetails(), data.getDetails());
        }

        public int hashCode() {
            return Objects.hash(this.getElement(), this.getDetails());
        }
    }
}

