/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.instantapps.sdk.api;

import com.google.android.instantapps.sdk.api.ExtendedSdk;
import com.google.android.instantapps.sdk.api.TelemetryManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nullable;

public class SdkLoader {
    @Nullable
    public ExtendedSdk loadSdk(File implementationJar, TelemetryManager.HostApplication hostApplication, String hostAppVersion) {
        try {
            URLClassLoader childClassLoader = new URLClassLoader(new URL[]{implementationJar.toURI().toURL()}, this.getClass().getClassLoader());
            Iterator<ExtendedSdk> iterator = ServiceLoader.load(ExtendedSdk.class, childClassLoader).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ExtendedSdk sdk = iterator.next();
            if (sdk.getApiRevision() < 4) {
                return null;
            }
            sdk.getTelemetryManager().setAppProperties(hostApplication, hostAppVersion);
            return sdk;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

