/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.core.DefaultParserCallback;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigNavigationActionsFactory
extends DefaultParserCallback {
    private static final Key<EditorConfigNavigationActionsFactory> NAVIGATION_FACTORY_KEY = Key.create((String)"editor.config.navigation.factory");
    private final List<String> myEditorConfigFilePaths = ContainerUtil.newArrayList();

    private EditorConfigNavigationActionsFactory() {
    }

    @NotNull
    public List<AnAction> getNavigationActions(@NotNull Project project) {
        ArrayList actions = ContainerUtil.newArrayList();
        List<VirtualFile> editorConfigFiles = this.getEditorConfigFiles();
        for (VirtualFile editorConfigFile : this.getEditorConfigFiles()) {
            actions.add(DumbAwareAction.create((String)EditorConfigNavigationActionsFactory.getActionName(editorConfigFile, editorConfigFiles.size() > 1), event -> OpenFileAction.openFile((VirtualFile)editorConfigFile, (Project)project)));
        }
        return actions.size() <= 1 ? actions : Collections.singletonList(new NavigationActionGroup(actions.toArray(AnAction.EMPTY_ARRAY)));
    }

    public boolean processEditorConfig(File configFile) {
        this.myEditorConfigFilePaths.add(configFile.getPath());
        return true;
    }

    public boolean processFile(File file) {
        this.myEditorConfigFilePaths.clear();
        return true;
    }

    @NotNull
    private static String getActionName(@NotNull VirtualFile file, boolean withFolder) {
        String fileName = EditorConfigPresentationUtil.getFileName(file, withFolder);
        return !withFolder ? EditorConfigBundle.message("action.open.file", fileName) : fileName;
    }

    @NotNull
    public List<VirtualFile> getEditorConfigFiles() {
        ArrayList files = ContainerUtil.newArrayList();
        for (String path : this.myEditorConfigFilePaths) {
            VirtualFile file = VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)true);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    @NotNull
    public static EditorConfigNavigationActionsFactory getInstance(@NotNull VirtualFile file) {
        EditorConfigNavigationActionsFactory instance = (EditorConfigNavigationActionsFactory)((Object)file.getUserData(NAVIGATION_FACTORY_KEY));
        if (instance == null) {
            instance = new EditorConfigNavigationActionsFactory();
            file.putUserData(NAVIGATION_FACTORY_KEY, (Object)instance);
        }
        return instance;
    }

    private class NavigationActionGroup
    extends ActionGroup {
        private final AnAction[] myChildActions;

        private NavigationActionGroup(AnAction[] actions) {
            super("Open EditorConfig File", true);
            this.myChildActions = actions;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return this.myChildActions;
        }
    }
}

